 Avoiding reevaluation of isSubClassOf makes the offline extensionalization process tractable, though it still takes more than 13 hours, as shown in Table 17b. We also tried implementing the avoiding reevaluation technique on isMemberOf. But, for our task, very few ismemberof facts are known until runtime, and the cost of overhead outweighs the benefit, making extensionalization slower. 

## 6.3.Minimizing Code

 Another efficiency improvement can be implemented if certain knowledge is available prior to run time. Given a list of all of the predicates that are used in 1) the ontology, 2) the dynamic changes, and 3) the queries, it may be possible to eliminate some of the rules, thus improving efficiency of the extensionalization process. In addition, the same technique can be used to eliminate rules in the run time program. The idea is to figure out which of the rules are actually necessary, because the unnecessary rules can be dropped, improving efficiency. If a rule can never successfully fire, then it is unnecessary. Also, if no query will ever result in testing a rule, then that rule is unnecessary. More precisely, a rule is a necessary *rule* only if it is both *satisfiable* and *testable*. To determine which rules are satisfiable and testable, it is necessary to figure out which predicates are satisfiable and testable, respectively. The algorithm that defines satisfiable rules and predicates is presented in Table 19a, and Table 19b shows how to determine which rules and predicates are testable. (In addition, we were able to drop more rules by assuming that the knowledge base was already consistent, eliminating the need to test for consistency.) 
 After removing all of the unnecessary rules, the extensionalization process only took 6.5 hours, as shown in Table 17c. And the online processes can run much faster, because the Prolog compiler can be applied to all of the predicates that are not changed dynamically. Table 15c shows that it requires only 10 milliseconds to assimilate the two dynamic changes and 130 milliseconds to answer the two queries. (The dynamic changes and queries used in our experiments are briefly described near the beginning of Section 6.) These results satisfy the requirements of our military task. 

## 7. Related Work

 Recent research has addressed similar issues and problems concerning the interaction of Semantic Web ontology and rule technologies and logic programming. Related work includes research on answer set programming (Eiter *et al.* 2004; Heymans & Vermeir 2003), disjunctive logic programming (Maedche & Volz 2003; Minker & Seipel 2002), constructive negation (Barták & Roman 1998), and Description Logic Programming (DLP) (Grosof 2003). However, we have not yet had an opportunity to investigate this other work enough to intelligently comment on it. Our preliminary experimentation with answer set programming, however, seems to demonstrate across-the-board gains in efficiency, compared to our Prolog implementation. But this work is as yet incomplete. 

## 8. Discussion

 The SWORIER system, given ontologies and rules, serves as an engine that responds to queries. This type of work will result in a significant enhancement to the Semantic Web, by providing a generally useful service to any application that requires information from the Semantic Web. SWORIER is also amenable to dynamic changes, quickly assimilating new facts or retracting old facts in an operational setting. Although it cannot handle dynamic additions, 