 Our initial experiments were set in a military command and control domain with a supply convoy moving through an unsecured area. Figure 1 presents an example situation, where a convoy is moving north along the primary route, approaching the location where intelligence has reported an enemy sniper is stationed. New information can become available at any time, such as the discovery of a theater object or the beginning of a sandstorm. The system has rules that trigger alerts and recommendations to report to the convoy commander. For example, in the situation shown in Figure 1, an enemy unit is within the convoy's region of interest (the circle surrounding the convoy), so the system might tell the convoy commander, "ALERT: Intelligence report of enemy sniper in the vicinity." and "RECOMMENDATION: Take alternate route." 
 Most knowledge representation languages and knowledge-based systems utilize a restricted version of First Order Logic (FOL). FOL, however, is semi-decidable. It is decidable in that if a theorem is logically entailed by a FOL theory, a proof will eventually be found, but it is undecidable in that if a theorem is not logically entailed, a proof of that may never be found. But decidability here does not mean tractability, and in general even inference in the simpler propositional calculus is NP-complete (Cadoli *et al.* 1999), i.e., usually unable to be processed in less than exponential time. 

![0_image_0.png](0_image_0.png)

 To make inference tractable, various approaches in the field of *knowledge compilation*, which involves converting a knowledge base into a more concise or tractable representation, have been devised (Cadoli & Donini 1997; Darwiche & Marquis 2001). One approach is to syntactically restrict the knowledge representation language, sacrificing expressiveness for tractability and efficiency (de Bruijn *et al.* 2004). Logic programming (LP), description logic 
(DL), and description logic programming (an emerging field that weds DL and LP) take this approach (Ait-Kaci 1991; Grosof *et al.* 2003; Hitzler *et al.* 2005; Van Roy 1990; Volz *et al.* 2003). For example, OWL is a DL that defines a tractable subset of First-Order Logic (Bechhofer et al. 2004; Daconta *et al.* 2003). An alternative is to employ theory approximation (Kautz & 