
## 3.1. Translating Facts

 SWORIER uses a syntax different from that typically found in previous work. For example, Volz *et al.* (2003) would produce the translation of Table 2d, instead of the translation in Table 2a. But we note that the syntax used by Volz *et al.* (2003) cannot represent "every class that smith is a member of" with X(smith), because most Prolog implementations disallow predicate variables. In contrast, by making the class names and property names be arguments instead of predicates, SWORIER has the flexibility to generalize on them with, for example, ismemberof(smith, X). 

| a.   | ismemberof(smith, sniper).  haspropertywith(smith, hasCombatIntent, friendlyIntent).                                                           |
|------|------------------------------------------------------------------------------------------------------------------------------------------------|
| b.   | ismemberof(X, redForceTheaterObject) :-   isMemberOf(X, redForceTheaterObject). ismemberof(smith, sniper).  haspropertywith(T, hasSpeed, S) :- |
| c.   | hasPropertyWith(T, isDescribedBy, G),   hasPropertyWith(G, hasSpeedObservation, S).                                                            |
| d.   | sniper(smith).  hasCombatIntent(smith, friendlyIntent).                                                                                        |

## 3.2. General Rules

 The General Rules are meant to capture the semantics of the primitives in OWL. For example, the rules in Table 3a enforce the transitivity of subclass. Note that there are two different predicates: issubclassof and isSubClassOf. One predicate would be insufficient, because Table 3b has left recursion, resulting in an infinite loop. 

## Table 3. The Transitive Closure Of Subclass

| a.   | isSubClassOf(C, D) :- issubclassof(C, D).  isSubClassOf(C, E) :- issubclassof(C, D), isSubClassOf(D, E).   |
|------|------------------------------------------------------------------------------------------------------------|
| b.   | isSubClassOf(C, E) :- isSubClassOf(C, D), isSubClassOf(D, E).                                              |

 With two different subclass predicates, some questions must be answered. Should the user submit queries with issubclassof or isSubClassOf? Also, which form should the input from the XSLTs be? If the input used isSubClassOf, then neither of the rules in Table 3a would ever succeed, thus the input must use issubclassof. On the other hand, queries should use isSubClassOf because the issubclassof set of facts is incomplete none of the subclass relationships that are derived by transitivity are captured by issubclassof. Note that the issubclassof set of facts is a subset of the isSubClassOf set of facts, because of the first rule in Table 3a, which is called the *conversion rule* for subclass. 

 For consistency, we created two cases of each predicate, all-lowercase and camelcase.2 Also, each predicate has a conversion rule. The XSLT facts always use the all-lowercase forms of predicates, while the user queries are always in camelcase. (However, the developer decides how to spell the names of constants, such as hasSpeed in Table 2c.) And any rules, other than recursive rules and conversion rules, follow the convention: 