All predicates in the body of the rule are camelcase, and the predicate in its head is all-lowercase.

As an example, see the second rule in Table 2c. Using camelcase predicates in the rule's body guarantees that the rule is triggered by everything that can be derived for that predicate in either case. And using the all-lowercase predicate for the rule's head insures that any facts generated by the rule will hold for both cases of the predicate. 

## 3.3. Translating Rules

 Some of the inputs provided to SWORIER are RuleML or SWRL rules that were created by the developer. It is not difficult to translate these rules into Prolog, because they are written in Horn Clause form. However, we cannot control which rules are provided nor how they are written. Problems can emerge, such as the infinite loop in Table 2b, which was generated by the RuleML rule in Table 1b. In addition, the order in which rules are listed and the order of the terms in the rules' bodies can have significant effects, much like order of join evaluation in database languages such as SQL. Another concern is that the input could include rules that produce duplicate copies of a fact. (See Section 4.9.) And the rules might be inefficient. 

 There are ways to correct or at least mitigate some of these problems. For example, we could apply transformations as for logic queries in the form of rewrite rules such as "magic sets" optimization (Cadoli *et al.* 1999; Sippu & Soisalon-Soininen 1996). But currently, we must impose strong requirements on the developer, who may need to be very familiar with Prolog programming techniques, the logical consequences of the facts in the ontologies, and the General Rules. 

## 4. Challenges

 We are following the groundbreaking work of Volz *et al.* (2003), who were among the first researchers to investigate OWL-to-Prolog translation. They discussed a number of problems that they encountered in the course of their work. Now we are proposing solutions for several of these problems, some of which are currently implemented in SWORIER. 

## 4.1. Negation

 Negation in Prolog is not the same as negation in OWL, RuleML, and SWRL. Prolog has finite-failure negation, which means that not(T) is true if it is not possible to prove that T is true. Alternatively, with the *logical negation* of OWL, RuleML, and SWRL, not(T) is true if it can be proven that T is false. (In both cases, not(T) is false if T can be proven true.) In order to close this gap, we have created a Prolog predicate called logicNot, and we are developing rules to capture the semantics of logical negation. The logicNot predicate takes one argument, which must be a term: logicNot(<term>). Three examples are presented in Table 4. 

## Table 4. Logicnot 

![0_Image_0.Png](0_Image_0.Png) Logicnot(Ismemberof(Jones, Sniper)). Logicnot(Issubclassof(Theaterobject, Convoy)). Logicnot(Logicnot(Isclass(Theaterobject))).
