
## 4.2. The Open World Assumption

 In Prolog, the *closed world assumption* holds, which means that anything that cannot be proven true must be false. Alternatively, OWL has an *open world assumption*, meaning that a term is false only if it can be proven false. So, in Prolog, a term can only be true or false, while OWL also allows for the possibility that its truth value cannot be determined from the available information. This distinction is addressed with the logicNot predicate, which was presented in Section 4.1. If the user wants to ask a true/false question, Q, then it is necessary to submit two queries to SWORIER: Q and logicNot(Q). Table 5 shows how the system's responses to these queries should be interpreted. 

Table 5. A True/False Query 

?- Q. ?- logicNot(Q). Is Q true?

yes no yes 

no yes no no no unknown 

yes yes error 

 

## 4.3. Complementary And Disjoint Classes

 Volz *et al.* (2003) claimed that "OWL features the complementOf primitive, which cannot be implemented in Horn Logics due to the fact, that there may be no negation in the head..." With the introduction of the logicNot predicate, this is no longer a problem. We can handle the complementary classes as well as the disjoint classes with the rules in Table 6. 

* [10]

![0_image_0.png](0_image_0.png)

Table 6. Complementary and Disjoint Classes disjointClasses(C, D) :- complementaryClasses(C, D). 

logicNot(isMemberOf(I, C)) :- 
 disjointClasses(C, D), is_member_of(I, D). isMemberOf(I, C) :- 
 complementaryClasses(C, D), logicNot(is_member_of(I, D)).

## 4.4. Multiple Terms In The Head

 One notable limitation of Horn rules is that the head (conclusion) of a rule cannot have more than one term. This means, if the conclusion of a rule is the conjunction of terms, it is necessary to create multiple rules. For example, the logical statement in Table 7a requires two rules in Prolog, as shown in Table 7b. 

 But for the logical rule in Table 7c, "...no Horn clause can be stated, since disjunction in the head would occur..." (Volz et al, 2003). We propose to address this problem by creating a new Prolog predicate that can be put in the head. So Table 7c can then be translated into Table 7d by using this new or predicate, which takes two arguments, each of which must be a term. Of course, we must supplement General Rules in order to properly establish the correct semantics of disjunction. Some examples of those rules are shown in Table 7e. Note that the last rule requires the logicNot predicate. 

 Unfortunately, the head of the last rule in Table 7e is a variable, which is not allowed in Prolog. However, although it may not be possible to solve this problem in general, because we are limiting our analysis to OWL, there are a finite number of predicates with which that variable can be instantiated, and this set of predicates does not require any knowledge of the particular ontologies or rules that are provided by the developer. So we can create one rule for each predicate, and some examples are presented in Table 7f. 