

![0_image_0.png](0_image_0.png)

e.

f. 

## 4.5.Enumerated Classes

 "The owl:oneOf primitive can be partially supported." (Volz et al, 2003) This primitive, which corresponds to our Prolog predicate, isset, defines a class, C, extensionally by providing a set of all and only the individuals in the class, a0, ..., an. For example, Table 8a declares that there are exactly three members of the class combatIntent: friendlyIntent, hostileIntent, and unknownIntent. 

Table 8. Enumerated Class 

a. isset(combatIntent, [friendlyIntent, hostileIntent, unknownIntent]). 

b. isMemberOf(ai, C). for all i 

c. or(=(I, friendlyIntent), 

 or(=(I, hostileIntent), =(I, unknownIntent))) :- isMemberOf(I, combatIntent). 

 Volz *et al.* (2003) observed that Horn Logic rules could be developed that would draw the conclusions in Table 8b. But they also say that, "to support the other direction ... which states that every instance of C is one of the listed ai ... requires a disjunction in the consequent of the rule, which can not be provided by ... Horn Clauses." (Volz *et al.* 2003) However, with the or predicate, introduced in Section 4.4, this should no longer be a problem. Table 8c presents the rule that captures the semantics of the example in Table 8a. 

## 4.6.Error Messages

 It is desirable for SWORIER to test the data for consistency. For this purpose, we follow Volz *et al.* (2003) by implementing rules to catch inconsistencies, such as those in Table 9. (In order to check for errors, the developer must submit the query: error(X).) In each of these examples, the inconsistency is addressed by sending an error message to the developer. However, there are other ways to handle most inconsistencies. Examples will be presented in Sections 4.7 and 4.8. 

## Table 9. Error Messages

error(['A term cannot be both true and false.', P]) :- logicNot(P), P. error(['The empty class cannot contain anything.', I]) :- isMemberOf(I, nothing). 