 Prolog implicitly assumes that all variables in any rule are universally quantified. However, OWL can specify existentially quantified variables. For example, the OWL code in Table 10a states that every theater object is described by at least one observation artifact. There are three ways to enforce this restriction. The simplest is to report an error message if it is violated, as in Section 4.6. Volz *et al.* (2003) uses the technique of skolemization. And the third approach is to add new facts to the knowledge base, which is discussed in Section 4.8. Skolemization solves the problem of a violated existential restriction by letting a specific term represent the missing individual. This term must be unambiguous, so its argument variables are selected to make it distinct. For example, given the restriction in Table 10a, if there is a theater object, I, that is not described by any observation artifacts, then the term unnamedIndividual(I, describedBy, observationArtifact) is used to represent the required observation artifact. In general, the two rules in Table 10b are applied in order to insure that this term satisfies the existential restriction. 

![0_image_0.png](0_image_0.png)

## 4.8. Cardinality

 In OWL, there are three cardinality primitives: (1) minCardinality, (2) maxCardinality, and (3) cardinality. Each of these primitives takes three arguments: a class, a property, and a number. The primitives' meanings are that each individual in the given class participates in the given property with (1) at least, (2) at most, or (3) exactly the given number of unique individuals. 

![0_image_1.png](0_image_1.png)

