
## 2. Reaction-Diffusion Hexagonal Cellular Automaton

We study a totalistic cellular automaton, where a cell updates its state depending on just the numbers, not positions, of different cell-states in its neighborhoods. We consider a ternary state automaton. One cell-state, S**, is a dedicated substrate state:**
a cell in state S, whose neighbourhood is filled only with states S**, does not change** its state (S **is a an analogue of quiescent state in cellular automaton models). Two**
other states, A and B**, are assigned to be reactants.**
The cell-state transition rule can be written as follows:

## X T+1 = F(Σa(X) T, Σb(X) T, Σs(X) T),

where σp(x)
tis the number of cell x's neighbors with cell-state p ∈ {**A, B, S**} at time step t**. As for all classical cellular automata, all cells updates their states**
synchronously in discrete time-steps. Our automata are based on **a two-dimensional** lattice with hexagonal tiling. The neighborhood size is seven: the central cell and its six closest neighbors.

To give a compact representation of the cell-state transition rule, **we adopt the**
formalism in 4, and represent the cell-state transition rule as a matrix M = (Mij ),
where 0 ≤ i ≤ j ≤ 7, 0 ≤ i + j ≤ 7, and Mij ∈ {A, B, S}**. The output state of each**
neighborhood is given by the row-index i **(the number of neighbors in cell-state** A)
and column-index j (the number of neighbors in cell-state B**). We do not have to**
count the number of neighbors in cell-state S, because it is given by 7 − (i + j**). A** cell with a neighborhood represented by indexes i and j **will update to cell-state**
Mij **which can be read off the matrix. In terms of the cell-state transition function**
this can be presented as follows: x t+1 = MσA(x)
tσB(x)
t .

How do matrix M entries correspond to phenomena in reaction-diffusion chemical systems? The entries Mi0 = A and M0j = B, i > **0, symbolize the diffusion**
of reactants A and B. Entries Mij = p, p ∈ {A, B, S}**, can be interpreted as a**
quasi-chemical reaction iA + jB −→ p, where i molecules of species A react with j molecules of species B **to produce species**
p**. See detailed interpretations of some particular cases in** 4,21,5.

## 3. Breeding Glider-Supporting Rules

We have employed evolutionary computation techniques developed by Sapin et al 13,14,15,16 **for evolving cellular automata which support mobile localizations**
(gliders). We used an evolutionary algorithm that incorporates aspects of natural selection or survival of the fittest. It maintains a population of structures (usually initially generated at random) that evolves according to rules of selection, recombination, mutation, and survival, referred to as genetic operators. A shared 'environment' is used to determine the fitness or performance of each individual in the