# Decomposition During Search For Propagation-Based Constraint Solvers

Martin Mann1,⋆, Guido Tack2, and Sebastian Will1,⋆⋆
1 **Bioinformatics, Albert-Ludwigs-University Freiburg, Germany**
{mmann,will}@informatik.uni-freiburg.de 2 **Programming Systems Lab, Saarland University, Germany**
tack@ps.uni-sb.de Abstract. **We describe** decomposition during search **(DDS), an integration of And/Or tree search into propagation-based constraint solvers.**
The presented search algorithm dynamically decomposes sub-problems of a constraint satisfaction problem into independent partial problems, avoiding redundant work. The paper discusses how DDS interacts with key features that **make**
propagation-based solvers successful: constraint propagation, especially for global constraints, and dynamic search heuristics.

We have implemented DDS for the Gecode constraint programming library. Two applications, solution counting in graph coloring and protein structure prediction, exemplify the benefits of DDS in practice.

## 1 Introduction

Propagation-based constraint solvers owe much of their success **to a** best-ofseveral-worlds **approach: They combine classic AI search methods with advanced**
implementation techniques from the Programming Languages community and efficient algorithms from Operations Research. Furthermore, the **CP community** has developed a great number of propagation algorithms for global **constraints.**
In this paper, we present how to integrate And/Or search into propagationbased constraint solvers. We call the integration decomposition during search
(DDS). We take full advantage of all the features mentioned above that make propagation-based constraint solvers successful. The most interesting points, and main contributions of our paper, are how DDS interacts with and benefits from constraint propagation, especially in the presence of global constraints, and dynamic search heuristics. We exemplify the profit of DDS by exhaustive solution counting, an important application area of decomposing search strategies [3, 8].

Related work**. Only recently, counting and exhaustive enumeration of solutions of a constraint satisfaction problem (CSP) gained a lot of interest [1, 3,**
8, 21]. In general, the counting of CSP solutions is in the complexity class \#P, i.e. it is even harder than deciding satisfiability [19]. This class was defined by
⋆ **Supported by the EU project EMBIO (EC contract number 012835)**
⋆⋆ Supported by the EU Network of Excellence REWERSE (project number 506779)
arXiv:0712.2389v2 [cs.AI] 11 Jun 2008