reason for this is that each variable in a linear constraint functionally depends on all other variables: for any two variables xi and xj **in the constraint** Pn i=1 xi =
c, picking a value for xi determines xj **, when all other variables are assigned.** Therefore, we cannot arbitrarily pick values from the domains D(xi**) and** D(xj )
such that the constraint is satisfied.

Consequently, subgraphs covered by linear constraints stay connected until all its variables are assigned. When solving a problem where subsets of X are covered by non-decomposable constraints, we can guide the search heuristic for a decomposition into these subsets. On the other hand, in problems **where one**
non-decomposable constraint covers the whole variable set, it is obvious that search cannot profit from DDS.

## 5.2 Decomposable Constraints

To take full advantage of DDS, efficient algorithms for the detection of possible constraint decompositions are necessary. Good candidates for an integration are the propagation methods that already investigate the variable **domains. Unfortunately, these propagators are highly constraint specific and thus no single**
general detection procedure for all decomposable constraints can be given. But there are global constraints whose propagation algorithms and data structures either directly yield the decomposition as a by-product, or that can **be easily** extended for detection.

In the following, we discuss three important propagators that can **detect and**
compute a decomposition efficiently.

All-different**. In contrast to linear constraints, there is no functional dependency between variables for** All-different**, but the exact inverse - variables depend**
on the absence **of values in a domain. This yields a maximal potential for decomposition. R´egin's propagator for** All-different **[22] employs a** variable-value **graph,**
connecting each variable node with the value nodes corresponding to the current domain. We can observe that All-different **can be decomposed if and only if the**
variable-value graph contains more than one connected component. In Fig. 3 the variable-value graph for the simple initial example is shown. As connected components of this graph have to be computed anyway during the propagation, we can get the constraint decomposition without any additional overhead. This technique generalizes to the **global cardinality constraint**.

Slide**. Introduced by Bessiere et al. [4],** Slide slides a k-ary constraint c **over**
a sequence of variables, i.e. it holds if c(xi, . . . , xi+k−1**) holds for all 1** ≤ i ≤
n − k **+ 1.** Slide can be split into two at variable xd **if the individual constraints**
involving xd **are entailed (see Fig. 4). Entailment happens at the latest when**
all variables between xd−k+1 and xd+k−1 **are assigned. Depending on how soon**
the individual c **are entailed, we can decompose even earlier.** Slide **establishes**
a dependency of a fixed width **between variables, so that once that width is** reached, the constraint can be decomposed. Note, this constraint decomposition is not complete and only detects certain non-trivial products along **the variable**