

![0_image_0.png](0_image_0.png)

## 6 Implementation

Our implementation of DDS extends Gecode, a C++ **constraint programming library. In this section, we give an overview of relevant technical details of Gecode,**
and discuss the four main additions to Gecode that enable DDS: access to the constraint graph, decomposing global constraints, integrating Decompose **into**
the search heuristic, and specialized search engines. The additions **to Gecode** comprise only 2500 lines (5%) of C++**code and enable the use of DDS in any** CSP modeled in Gecode. DDS will be available as part of the next release of Gecode.

## 6.1 Gecode

The Gecode library [11] is an open source constraint solver implemented in C++. It lends itself to a prototype implementation of DDS because of four **facts:**

1. Full source code enables changes to the available propagators.

2. The reflection capabilities allow access to the constraint graph. 3. Search is based on recomputation and copying, which significantly **eases the**
implementation of specialized branchings and search engines.

4. It provides good performance, so that benchmarks give meaningful results.

## 6.2 Constraint Graph

In most CP systems, the constraint graph is implicit in the data structures for variables and propagators. Gecode, e.g., maintains a list of propagators, and each propagator has access to the variables it depends on.

For DDS, a more explicit representation is needed that supports the computation of connected components. We can thus either maintain an **additional,**
explicit constraint graph during propagation and search, or extract the graph from the implicit information each time we need it. For the prototype implementation, we chose the latter approach. We make use of Gecode's reflection API, which allows to iterate over all propagators and their variables. Through reflection, we construct a graph using data structures from the boost **graph library [6],**
which also provides the algorithm that computes connected components.