Assigned variables are independent of all other variables as discussed in Sec. 4. Therefore, they are reported as individual partial problems (connected components) but are ignored to avoid useless trivial decompositions without any effect. Instead these already solved single variable CSPs are added **to an arbitrary partial problem that covers at least one unassigned variable. If the final** number of such "non-solved" partial problems is at least two, a problem decomposition is initialised. This significantly speeds up the search process because only profitable decompositions are done.

## 6.3 Global Constraint Decomposition

As discussed in Sec. 5, it is absolutely essential for the success of DDS to consider constraint decompositions of global constraints when computing the connected components.

There are two possible implementation strategies for decomposing global constraints. A propagator can either detect decomposability during propagation and replace itself with several propagators on subsets of the variables. Or, alternatively, the constraint decompositions are only computed on demand **when the**
constraint graph is required for connected component analysis. We implemented the latter option.

This again leaves two possible implementations. When the constraint graph is decomposed, one propagator (for a global constraint) may belong to two connected components. When search continues in the individual components, we can either use the propagator as it is in both components, or replace it by its decomposition. The latter option has the advantage that the smaller propagator may be more efficient (as it can ignore the variables outside its connected component). However, for simplicity, we implemented the former.

## 6.4 Decomposing Branchings

Once we have identified connected components in the constraint graph, we have to create the partial problems that correspond to these components. In Gecode, we exploit the duality of choice and decomposition: both add branches to the search tree. The following observation leads to a simple and efficient implementation. If the heuristic is restricted such that it only selects variables inside one connected component, also propagation will only occur for variables of that component: For Xˆ independent in P, propagate(P)|Xˆ **= propagate(**P|Xˆ).

For our Gecode implementation, Decompose **is thus realized as a** branching.

A branching in Gecode usually implements LeftChoice/RightChoice**. For** DDS, we extend it to also implement Decompose**: If decomposition is possible,**
the branching limits further search to the variables in one connected component per branch. Otherwise, it just creates the usual choices according to the heuristic.

Branchings in Gecode are fully programmable. They have to support **two operations**3: description and commit. description **returns an abstract descrip-**3
**In fact, branchings in Gecode have a slightly more complex interface, which we**
deviate from to simplify presentation.