

![0_image_0.png](0_image_0.png)

![0_image_1.png](0_image_1.png)

## 8 Discussion

The paper introduces decomposition during search **(DDS), an integration of**
And/Or search with propagation-based constraint solvers. DDS dynamically decomposes CSPs, avoiding much of the redundant work of standard **tree search**
when exploring huge search spaces, e.g. of \#P**-hard counting problems.**
We discuss the interaction of DDS with such vital and essential features as global constraints and dynamic variable ordering. The techniques presented here have been implemented for Gecode.

The empirical evaluation on graph coloring and protein structure prediction shows the huge potential of DDS in terms of search tree size reduction and already high true runtime speedup. The speedup proves that DDS can be implemented competitively, and with a reasonable overhead. We expect even higher speedups by improving the constraint graph representation and its incremental maintenance, which is a current area of development. However, one experience from our experiments is that it is highly problem-specific whether the **constraint** graph allows for decomposition. We partly explain this by pointing out that some constraints (e.g. linear (in-)equations) inherently hinder decomposition.

We envision promising future research in the following directions. First, providing efficient access to the constraint graph. Second, the development of specifically tailored heuristics for DDS focusing on dynamic variable selection **or domain splitting. Such heuristics should employ information about the constraint**
graph, to decompose the problem as often as possible and in a well-balanced way. Decomposition-directed heuristics might however counteract problem specific heuristics. Balancing such heuristics is a further research direction.

Finally, solving optimization problems using And/Or branch-and-bound (BAB)
search [15] seems an obvious extension. However, our first experiments using a prototypical DDS extension of BAB show much smaller benefits than **for counting (similar to the results in [15, 16]).**
Acknowledgements**. We thank Christian Schulte and Mikael Lagerkvist for** fruitful discussions about the architecture and the paper, and the reviewers of earlier versions of this paper for constructive comments. Martin Mann is supported by the EU project EMBIO (EC contract number 012835). Sebastian Will is partially supported by the EU Network of Excellence REWERSE (project number 506779).

## References
