of our Gecode implementation, we study the practical impact of DDS **in Sec. 7**
by counting solutions for random instances of two important CSPs, **graph coloring and protein structure prediction. Both examples are hard counting problems**
(in class \#P). The study shows high average speedups and reductions in search tree size, even using our prototype implementation. These two sections therefore provide evidence that DDS can be integrated into a modern constraint programming system in a straightforward and efficient way. The paper finishes with a summary and an outlook on future work in Sec. 8.

## 2 Preliminaries

This section defines the central notions that we want to use to talk **about constraint satisfaction problems.**
A Constraint Satisfaction Problem (CSP) is a triple P = (X, D, C**), where**
X = {x1, . . . , xm} is a finite set of variables, D **a function of variables to their**
associated value domains, and C a set of constraints. An n**-ary** constraint c ∈ C is defined by the tuple of its n variables vars(c) and a set of n**-tuples of the allowed** value combinations. We feel free to interpret vars(c**) as the set of variables of** c. A domain D entails a constraint c **if and only if all possible value combinations** of the variable domains of vars(c) in D are allowed tuples for c. A solution of a CSP is an assignment of one value v ∈ D(xi) to each variable xi ∈ X **such that**
all c ∈ C **are entailed. The** set of solutions of a CSP P **is denoted by sol(**P).

Based on these definitions some important properties of a CSP can be defined.

A CSP P = (X, D, C) is solved if and only if ∀x ∈ X : |D(x)| **= 1 and sol(**P) 6= ∅. P is failed if and only if sol(P) = ∅ and satisfiable **otherwise. A CSP** P
′is stronger than P (P
′ ⊑ P**) if and only if sol(**P
′) = sol(P) and ∀x ∈ X′: D′(x) ⊆ D(x).

The constraint graph of a CSP P = (X, D, C) is a hypergraph GP = (**V, E**),
where V = X and E = {vars(c) | c **∈ C}**.

## 3 Decomposition During Search

In this section, we recapitulate And/Or tree search. Then, we present a highlevel model of how to integrate And/Or tree search into a propagation-based constraint solver. We call this integration decomposition during search **(DDS).**

## 3.1 And/Or Tree Search

Let us look at an example to get an intuition for And/Or search. Assume P = (X, D, C) with X = {A, B, C, D}, D(A) = {3, 5}, D(B) = {3, 4}, D(C) = D(D) = {1, 2}, and C = 'A, B, C, D **are pairwise different'. Figure 1 presents** a corresponding search tree for a plain depth-first tree search. **Each node is a** propagated sub-problem of P **and is visualized as a constraint graph. As usual,** a node is equivalent to the disjunction **of all its children.**
Even this tiny example demonstrates that plain DFS may perform redundant work: The partial problem on the variables C and D **is solved redundantly for**