Variable selection**. The variable selection strategy of such a heuristic is crucial for the size of the search tree and often problem specific. Nevertheless, a**
common method for variable selection is 'first-fail', which selects by minimal domain size. Other strategies use the degree in the constraint graph or the minimal/maximal/median value in the domain. Static variable orderings are in **many**
cases inferior to these dynamic strategies. To gain the best search performance by DDS, the variable selection further has to induce constraint graph decompositions as early as possible.

Heuristics that maximize decomposition**. In order to maximize the number** of decompositions during search, the heuristic can be guided by the **constraint** graph. Such a heuristic may compute e.g. cut-points, bridges, or more powerful
(minimal) cut-sets/separators [16]. Our framework is well prepared to accommodate such complex strategies, in particular because our method already builds on access to the constraint graph.

An open problem is the possible contradiction of heuristics aimed at decomposition versus fine-tuned problem specific heuristics. The heuristic aimed at decomposition may yield many partial problems that are not satisfiable and therefore lead to an inefficient search. On the other hand, the problem specific heuristic might yield no or only a few decompositions, which makes DDS unprofitable. Therefore, no general rule can be given. But our experiments suggest that a hybrid heuristic of selecting the variable with the highest node **degree,** and using the problem-specific heuristic as a tie breaker, yields good **results (see** Sec. 7). Order of exploration of partial problems**. It is of high importance in which**
order the children of and**-nodes, the partial problems, are explored. After detecting inconsistency in one partial problem, the exploration of the remaining partial**
problems is needless. Given an unsatisfiable problem, a good variable selection heuristic yields a failure during search as soon as possible to avoid unnecessary search (this is called the fail-first **principle). Assuming that we already have such**
a good variable selection heuristic, we use it to guide the partial problem ordering of DDS: (1) apply the selection to the whole (non-decomposed) variable set and (2) choose the partial problem first that contains the selected variable. That way, a good heuristic will lead to failure in the first explored partial problem if the decomposed problem has no solution. Further, it decreases the probability that the remaining partial problems are not satisfiable (in case the first is). This mitigates the effect that failure may be detected late using DDS, mentioned in Subsec. 3.2.

## 5 Global Constraints

One of the key features of modern constraint solvers is the use of **global constraints to strengthen propagation. Therefore, a search algorithm has to support**
global constraints in order to be practically useful in such systems. We describe the problems global constraints pose for DDS, and how to tackle them.