For an n**-ary (global) constraint, the constraint graph contains a hyperedge**
that connects all n **variable nodes. Consider a CSP for** All-different(**w, x, y, z**)
with w, x ∈ {0, 1}, y, z ∈ {2, 3}**. In this model, we cannot decompose, although** the binary constraints a 6= b for a ∈ {w, x}, b ∈ {y, z} **are entailed! Thus, in the**
current set-up, the global All-different **unnecessarily prevents decomposition.**
The solution to this problem is to take the internal **structure of global constraints into account: the global constraint itself can be decomposed into smaller**
constraints (on fewer variables). We will call this the constraint decomposition to distinguish it from constraint graph decomposition.

If we reflect the constraint decomposition of global constraints in **the constraint graph, we recover all the decompositions that were prevented by the**
global constraints before.

For our example involving the All-different **constraint, the constraint graph**
would contain two constraints, w 6= x and y 6= z**, instead of the one global**
All-different**. The graph can now be decomposed.**
As global constraints often cover a significant portion of the variables in a problem, global constraint decomposition is an essential prerequisite to make a constraint graph decomposition by DDS possible. Note that global constraint decomposition is independent of the other constraints present in the constraint graph; typical permutation problems, for instance, feature one **global** All-different that forces all variables to form a permutation, and then several **other constraints** that determine the concrete properties of the permutation. Applying DDS to such a problem is useless unless the constraint decomposition of the All-different is considered when computing connected components.

In general, a global constraint can be decomposed if and only if its extension
(the set of allowed tuples) can be represented as a non-trivial product, i.e. a product of non-singleton sets. For the above example, the set of **allowed tuples**
is {(0, 1),(1, 0)} × {(2, 3),(3, 2)}**. If a constraint can be represented as such a** non-trivial product a×b**, we can decompose it into two independent constraints,** one with the tuples of a**, the other with the tuples of** b.

Formally, defined in terms of CSP solutions, we say a constraint c ∈ C **of a**
CSP P = (X, D, C) is decomposable into the constraints c1, . . . , ck**, if and only if**

$$vars(c)=\bigcup_{i\in[1,k]}vars(c_{i})\quad\text{and}$$ $$\forall_{i\neq j\in[1,k]}:vars(c_{i})\cap vars(c_{j})=\emptyset\quad\text{and}$$ $$sol(P)=sol(P^{\prime})$$  with $P^{\prime}=({\cal X},{\cal D},{\cal C}^{\prime})$ and ${\cal C}^{\prime}=\{\;c_{1},\ldots,c_{k}\}\cup{\cal C}\setminus\{\;c\}$.  

## 5.1 Non-Decomposable Constraints

Some global constraints are never decomposable during a constraint search, since they cannot be decomposed for any arbitrary domain D.

For example, the tuples that satisfy a linear constraint, such as a linear equation or inequation, can never be represented as a non-trivial **product. The**