It is easy to see that for unbiased coins the most likely outcome is 1 head and thus the optimal strategy for the agent is to always guess 1. However if the coins are significantly biased it might be optimal to guess either 0 or 2 heads depending on the bias. If this were the case, then after a number of iterations of the game an intelligent agent would realise that the coins were probably biased and change its strategy accordingly.

With a little imagination, seemingly any sort of game, challenge, problem or test can be expressed in this simple framework without too much effort. It should also be emphasised that this agent-environment framework says nothing about how the agent or the environment actually work; it only describes their roles.

## 3.2 Formal Agent-Environment Framework

Having introduced the agent-environment framework, we will now formalise it, along with the other components of our informal definition of intelligence. We begin with agent-environment interaction. Agent-environment interaction. The agent sends information to the environment by sending symbols from some finite set, for example, A := {left, right, up, down}. We will call this set the action space and denote it by A. Similarly, the environment sends signals to the agent with symbols from a finite set called the perception space, which we will denote P. The reward space, denoted by R, will always be a subset of the rational unit interval [0, 1] ∩ Q. Every perception consists of two separate parts; an observation and a reward. For example, we might have P := {(cold, 0.0),(warm, 1.0),(hot, 0.3)} where the first part describes what the agent observes (cold, warm or hot) and the second part describes the reward (0.0, 1.0, or 0.3).

To denote symbols being sent we will use the lower case variable names a, o and r for actions, observations and rewards respectively. We will also index these in the order in which they occur, thus a1 is the agent's first action, a2 is the second action and so on. The agent and the environment will take turns at sending symbols, starting with the environment. This produces a history of observations, rewards and actions which we will denote by, o1r1a1o2r2a2o3r3a3o4 **. . .**. This turn taking behaviour is not a serious restriction, nor is the fact that the first signal sent is a perception. The agent. Formally, the agent is a function, denoted by π, which takes the current history as input and chooses the next action as output. We do not want to restrict the agent in any way, in particular we do not require that it is deterministic. A convenient way of representing the agent then is as a probability measure over actions conditioned on the complete interaction history. Thus, π(a3|o1r1a1o2r2) is the probability of action a3 in the third cycle, given that the current history is o1r1a1o2r2. A deterministic agent is simply one that always assigns a probability of 1 to a single action for any given history. As the history that the agent can use to select its action expands indefinitely, the agent need not be Markovian. Indeed, how the agent produces its distribution over actions for any given history is left open. In artificial intelligence the agent will of course be a machine and so π will be a computable function. In general however, π could be anything:
An algorithm that generates the digits of √e as outputs, an incomputable function, or even a human pushing buttons on a keyboard.