at least on average, rewarded for correctly applying Occam's razor, even if in some cases this leads to failure.

There is another subtlety that needs to be pointed out. Often intelligence is thought of as the ability to deal with complexity. Or in the words of the psychologist Gottfredson, ". . . g is the ability to deal with cognitive complexity - in particular, with complex information processing."[Got97b] It is tempting then to equate the difficultly of an environment with its complexity. Unfortunately, things are not so straightforward. Consider the following environment:
3.5 Example. Imagine a very complex environment with a rich set of relationships between the agent's actions and observations. The measure that describes this will have a high complexity. However, also imagine that the reward signal is always maximal no matter what the agent does. Thus, although this is a very complex environment in which the agent is unlikely to be able predict what it will observe next, it is also an easy environment in the sense that all policies are optimal, even very simple ones that do nothing at all. The environment contains a lot of structure that is irrelevant to the goal that the agent is trying to achieve.

From this perspective, a problem is thought of as being difficult if the simplest good solution to the problem is complex. Easy problems on the other hand are those that have simple solutions. This is a very natural way to think about the difficulty of problems, or in our terminology, environments.

Fortunately, this distinction does not affect our use of Occam's razor. When we talk about an hypothesis, what we mean is a potential model of the environment from the agent's perspective, not just a model that is sufficient with respect to the agent's goal. From the agent's perspective, an incorrect hypothesis that fails to model much of the environment may be optimal if the parts of the environment that the hypothesis fails to model are not relevant to receiving reward. However, when Occam's razor is applied, we apply it with respect to the complexity of the hypotheses, not the complexity of good solutions with respect to an objective. Thus, to reward agents on average for correctly using Occam's razor, we must weight the environments according to their complexity, not their difficulty.

Our remaining problem now is to measure the complexity of environments. The Kolmogorov complexity of a binary string x is defined as being the length of the shortest program that computes x:

## K(X) := Min P{L(P) : U(P) = X},

where p is a binary string which we call a program, l(p) is the length of this string in bits, and U is a prefix universal Turing machine U called the reference machine.

To gain an intuition for how this works, consider a binary string 0000 **. . .** 0 that consists of a trillion 0s. Although this string is very long, it clearly has a simple structure and thus we would expect it to have a low complexity. Indeed this is the case because we can write a very short program p that simply loops a trillion times outputting a 0 each time. Similarity, other strings with simple patterns have a low Kolmogorov complexity.

On the other hand, if we consider a long irregular random string 111010110000010 **. . .** then it is much more difficult to find a short program that outputs this string. Indeed it is possible to prove that there are so many strings of this form, relative to the number