Here we see two distinct notions of intelligence, a performance based one and an information content one. This is similar to the distinction between fluid intelligence and crystallized intelligence made by the psychologist Cattell (see Subsection 2.5). The performance notion of intelligence is similar to our definition with the expectation that performance is measured in a complex environment rather than across a wide range of environments. This perspective appears in some other definitions also,
". . . the ability to solve hard problems." M. Minsky [Min85] "Achieving complex goals in complex environments" B. Goertzel [Goe06]
Interestingly, Goertzel claims that an AI system he is developing should be able to, with sufficient resources, perform arbitrarily well with respect to the intelligence order relation, that is, the relation on which universal intelligence was originally based [LGP04].

Presumably then he does not consider his definition to be significantly incompatible with ours.

Some definitions emphasise not just the ability to perform well, but also the need for efficiency:
"[An intelligent agent does what] is appropriate for its circumstances and its goal, it is flexible to changing environments and changing goals, it learns from experience, and it makes appropriate choices given perceptual limitations and finite computation." D. Poole [PMG98]
". . . in any real situation behavior appropriate to the ends of the system and adaptive to the demands of the environment can occur, within some limits of speed and complexity." A. Newell and H. A. Simon [NS76]
"Intelligence is the ability to use optimally limited resources - including time - to achieve goals." R. Kurzweil [Kur00]
"Intelligence is the ability for an information processing agent to adapt to its environment with insufficient knowledge and resources." P. Wang [Wan95]
We consider the addition of resource limitations to the definition of intelligence to be either superfluous, or wrong. In the first case, if limited computational resources are a fundamental and unavoidable part of reality, which certainly seems to be the case, then their addition to the definition of intelligence is unnecessary. Perhaps the first three definitions above fall into this category.

On the other hand, if limited resources are not a fundamental restriction, for example a new model of computation was discovered that was vastly more powerful than the current model, then it would be odd to claim that the unbelievably powerful machines that would then result were not intelligence. Normally we do not judge the intelligence of something relative to the resources it uses. For example, if a rat had human level learning and problem solving abilities, we would not think of the rat as being more intelligence than a human due to the fact that its brain was much smaller.

While we do not consider efficiency to be a part of the definition of intelligence, this is not to say that considering the efficiency of agents is unimportant. Indeed, a key goal of