
## 5.2 Response To Common Criticisms

What we have attempted to do is very ambitious and so, not surprisingly, the reactions we get can be interesting. Having presented the essence of this work as posters at several conferences, and also as a 30 minute talk, we now have some idea of what the typical responses are. Most people start out skeptical but end up generally enthusiastic, even if they still have a few reservations. This positive feedback has helped motivate us to continue this direction of research. In this subsection, however, we will attempted to cover some of the more common criticisms.

It's obviously false, there's nothing in your definition, just a few equations.

Perhaps the most common criticism is also the most vacuous one: It's obviously wrong!

These people seem to believe that defining intelligence with an equation is clearly impossible, and thus there must be very large and obvious flaws in our work. Not surprisingly these people are also the least likely to want to spend 10 minutes having the material explained to them. Unfortunately, none of these people have been able to communicate why the work is so obviously flawed in any concrete way - despite in one instance having one of the authors chasing the poor fellow out of the conference centre and down the street begging for an explanation. If anyone would like to properly explain their position to us in the future, we promise not to chase you down the street! It's obviously correct, indeed everybody already knows this stuff. Curiously, the second most common criticism is the exact opposite: The work is obviously right, and indeed it is already well known. Digging deeper, the heart of this criticism comes from the perception that we have not done much more than just describe reinforcement learning. If you already accept that the reinforcement learning framework is the most general and flexible way to describe artificial intelligence, and not everybody does, then by mixing in Occam's razor and a dash of complexity theory, the equation for universal intelligence follows in a fairly straightforward way. While this is true, the way in which we have brought these things together has never been done before, although it does have some connection to other work, as discussed in Subsection 4.2. Furthermore, simply coming up with an equation is not enough, one must argue that what the equation describes is in fact "intelligence" in a sense that is reasonable for machines.

We have addressed this question in three main ways: Firstly, in Section 2 we developed an informal definition of intelligence based on expert definitions which was then piece by piece formalised leading to the equation for Υ in Subsection 3.3. This chain of argument strongly ties our equation for intelligence with existing informal definitions and ideas on the nature of intelligence. Secondly, in Subsections 3.4 and 3.5 we showed that the equation has properties that are consistent with a definition of intelligence. Finally, in Subsection 3.4 it was shown that universal intelligence is strongly connected to the theory of universally optimal learning agents, in particular AIXI. From this it follows that machines with very high universal intelligence have a wide range of powerful optimality properties. Clearly then, what we have done goes far beyond merely restating elementary reinforcement learning theory.

Assuming that the environment is computable is too strong. It is certainly possible that the physical universe is not computable, in the sense that the probability