
## 1 Introduction

Despite solid progress on many fronts over the last 50 years, artificial intelligence is still a very young field with many of its greatest achievements, and some of its most fundamental problems, yet to be tackled. From a theoretical perspective, one of the most fundamental problems in the field is that the very concept **of intelligence** remains rather murky. This is somewhat true in the context of humans, but it is especially true when we consider machines which may have completely **different** sensors, bodies, cognitive capacities and live in different environments to ourselves. What does "intelligence" mean for a machine? Perhaps the first attempt to answer this question, and certainly the only attempt that most researchers are aware of, is Alan Turing's famous imitation game [33]. Turing recognised how difficult it would be to explicitly define intelligence and thus attempted to sidestep the issue completely. Although this was a clever move, it leaves us with a test of **machine** intelligence that tells us almost nothing about what intelligence actually **is, and thus** is of little use as a foundation, either theoretical or practical, for our research.

Since then, a few bold researchers have tried to tackle this difficult problem in a more satisfactory way by proposing various definitions and tests of machine intelligence. By and large, these proposals have been ignored by the **community.**
Indeed to the best of our knowledge, no general survey of tests **and definitions of** intelligence for machines has ever been published.

We feel that to ignore a question as fundamental as the definition of machine intelligence is a serious mistake. In any science, issues surrounding fundamental definitions and methods of measurement play a central role and form the foundation on which theoretical advances are constructed and practical advances are measured. If we are to truly advance as a field over the next 50 years, we will need to return to this most central of problems in order to secure what artificial intelligence is and what it aims for. As a first step in this direction, it is necessary that researchers are at least aware of the many alternatives to Turing's tests that have **been proposed.** In this paper we hope to partly meet this need by providing the first general survey of tests and definitions of machine intelligence.

## 2 Turing Test And Derivatives

The classic approach to determining whether a machine is intelligent is the so called Turing test [33] which has been extensively debated over the last 50 **years [26].**
Turing realised how difficult it would be to directly definite intelligence and **thus** attempted to side step the issue by setting up his now famous imitation game: If human judges cannot effectively discriminate between a computer and a human through teletyped conversation, then we must conclude that the **computer is intelligent.**
Though simple and clever, the test has attracted much criticism. Block and Searle argue that passing the test is not sufficient **to establish intelligence [3, 28, 7].**