
## 9 C-Test

One perspective among psychologists who support the g**-factor view of intelligence,**
is that intelligence is "the ability to deal with complexity"[10]. Thus in a test of intelligence the most difficult questions are the ones that are the most complex because these will, by definition, require the most intelligence to solve. It follows then that if we could formally define and measure the complexity of test problems we could construct a formal test of intelligence. The possibility of doing this was perhaps first suggested by the complexity theorist Chaitin [5]. While this path requires numerous difficulties to be dealt with, we believe that it is the most natural and offers many advantages: It is formally motivated, precisely defined and potentially could be used to measure the performance of both computers and biological systems on the same scale without the problem of bias towards any particular species or culture.

One intelligence test that is based on formal complexity theory is the **C-Test**
from Hern´andez [13, 14]. This test consists of a number of sequence prediction and abduction problems similar to those that appear in many standard IQ **tests. Similar**
to standard IQ tests, the C-Test always ensures that each question has an unambiguous answer in the sense that there is always one hypothesis that is consistent with the observed pattern that has significantly lower complexity than the alternatives. The key difference to sequence problems that appear in standard intelligence tests is that the questions are based on a formally expressed measure of complexity, namely Levin's computable Kt **complexity [20] (rather than Kolmogorov's incomputable**
complexity [21]) to get a practical test. In order to retain the invariance property of Kolmogorov complexity, Levin complexity requires the additional assumption that the universal Turing machines are able to simulate each other in linear **time.**
The test has been successfully applied to humans with intuitively reasonable results [14, 12]. As far as we know, this is the only formal definition of **intelligence** that has so far produced a usable test of intelligence.

One criticism of the C-Test and Smith's tests is that the way intelligence is measured is essentially static, that is, the environments are passive. We believe that dynamic testing in active environments is a better measure of a system's intelligence. To put this argument another way: Succeeding in the real world requires you to be more than an insightful spectator! One must carefully choose actions knowing that these may affect the future.

## 10 Universal Intelligence

Another complexity based test is the universal intelligence **test [19]. Unlike the**
C-Test and Smith's test, universal intelligence tests the performance of an agent in a fully interactive environment. This is done by using the reinforcement learning framework in which the agent sends its actions **to the environment and receives**
observations and rewards **back. The agent tries to maximise the amount of reward**
7