Subhash Kak 

## Introduction

Stream computing is often seen to be embodied in compute-intensive kernel functions that are applied to each element in the data stream one at a time. These kernel functions operate in sequence in a pipelined fashion in what is essentially SIMD (single instruction multiple data) 
architecture. The advantage of doing this is the simplification of interconnects to get large increase in performance and in simplified programming. This processing is a take off on the style of computing that is found in DSP applications such as in voice, images, and video applied to a much larger range of applications. 

Here we speak of stream computing in a much larger philosophical setting that is sometimes expressed in the idea of *stream* of consciousness. In literature, this idea is meant to imply the internal monologue that goes on in the mind. Such a stream has no single focus and it may shift from one to another, suggesting that the processing that lies behind it corresponds to a variety of processing centers that randomly project - in sequence - in the theater of the mind. But the motivation for this technical paradigm is the imperative of neuroscience more than the literary allusion. The brain is composed of several modules each of which is essentially an autonomous neural network. Thus the visual network responds to visual stimulation and also during visual imagery, which is when one sees with the mind's eye. Likewise, the motor network produces movement and it is active during imagined movements. However, although the brain is modular, a part of it, located for most people in the left hemisphere, monitors the modules and interprets their individual actions in order to create a unified idea of the self. In other words, there is a higher integrative or interpretive module that synthesizes the actions of the lower modules [1]. Thus, if one were to construct a machine that is similar in organization to the brain, we would need a system of autonomic and parallel centers together with integrative processors that work at a higher level of abstraction to implement high level "intelligent" processing. It would be wise to use this framework to create new architectures to deal with high-volume data involving high-level reasoning. 

As a caveat it must be said that this, in itself, will not endow the system with biological type of intelligence since another hallmark of biological intelligence that we are not in a position to simulate effectively in our implementations is that of reorganization with respect to changing environment [2-4]. 

From a practical implementation point of view, one can view stream computing as an overarching paradigm of which the current SIMD implementations of uniform stream processing are an elementary embodiment. The general streaming paradigm would have several SIMD machines operate in parallel on many copies of the data followed by further processing on another machine that operates at a higher abstraction. The new computing paradigm should make it possible to perform rapid processing of fast, high-volume data streams. 