
## The Path To Streaming

Classical computers are based on ideas that developed in the 1930s and 1940s to give shape to the intuition of how the rational mind performs computation. The general-purpose computing machine was visualized to consist of four main parts. These are the parts relating to the arithmetic logic unit, memory, control, and interface with the human operator. 

![0_image_0.png](0_image_0.png)

The conception of the computer instrumented the formal notion of an algorithm. The innovative leap in building a general purpose device was the storing not only of data and the intermediate results of computation, but also the instructions that brought about the computation. In the classical computer's memory there is no fundamental distinction between data and instruction, which is considered a shortcoming by some. Other claimed shortcoming are: the memory is monolithic and it must be sequentially addressed; it is single dimensional whereas in nature patterns of memory are multidimensional; and the attributes of data are not stored together with it, which is in contrast to what obtains in a higher level language where we expect a generic operation to take on a meaning determined by the meaning of its operands. 

The reason why the architecture of the classical computer came to have this form is clear enough when we see it as an embodiment of serial computation carried out by the rational mind in arithmetic and other numerical tasks. However, whereas some computations carried out by humans (especially those dealing with numerical computations) do fall within the category that is well captured by serial computation, there are a vast number of other computations that do not. In particular, tasks associated with "intelligence," which typically involves processing enormous amounts of data do not involve deliberate computation. In such tasks, autonomous centers appear to carry out computations independently, reducing the dimensions of the data and mapping it into an abstract space where further computations are done. 