
## 6. Test Problem

We experiment a cGA using anisotropic selection on a Quadratic Assignment Problem (QAP): Nug30. Our aim here is not to obtain better results with respect to other optimization methods, but rather to observe the behavior of a cGA with AS. In particular, we seek an optimal value for the anisotropy degree.

## 6.1 The Quadratic Assigment Problem

The QAP is an important problem in both theory and practice. It was introduced by Koopmans and Beckmann in 1957 and is a modal for many practical problems [10].

The QAP can be described as the problem of assigning a set of facilities to a set of locations with given distances between the locations and given flows between the facilities.

The goal is to place the facilities on locations in such a way that the sum of the products between flows and distances is minimal.

Given n facilities and n locations, two n × n **matrices** D =
[dkl ] and F = [fij ] where dkl is the distance between locations k and l and fij the flow between facilities i and j**, the**
objective function is:

$$\Phi=\sum_{i}\sum_{j}d_{p(i)p(j)}f_{i j}$$
i
j
where p(i) gives the location of facility i **in the current permutation** p. Nugent, Vollman and Ruml suggested a set of problem instances of different sizes noted for their difficulty [3]. The instances they suggested are known to have multiple local optima, so they are difficult for a genetic algortihm. We experiment our algorithm on their 30 variables instance called Nug30.

## 6.2 Experiments

We consider a population of 400 individuals placed on a square grid. Each individual represents a permutation of
{1, 2, ..., 30}**. We need a special crossover that preserves the**
permutations:
- Select two individuals p1 and p2 **as genitors.**
- **Choose a random position** i.

- Find j and k so that p1(i) = p2(j) and p2(i) = p1(k). - swap positions i and j from p1 and positions i and k from p2.

- repeat n/3 times this procedure where n **is the length**
of an individual.

This crossover is an extended version of the UPMX crossover proposed in [11]. The mutation operator consists in randomly selecting two positions from the individual and exchanging these positions. The crossover rate is 1 and we perform one mutation per individual in average.

We consider 500 runs for each anisotropy degree. Each run stops after 1500 generations.

Figure 10 shows the average performance of the algorithm towards α: for each value of α **we average the best solution**
of each run. Performances are growing with α **and then fall** down as α **is getting closer to its limit value. This curve**
shows the influence of the selective pressure on the performances and how important it is to control it accurately.

The best average performance is observed for α = 0.86, which corresponds to a good exploration/exploitation tradeoff. In the neighborhood of this optimal value the algorithm favors propagation of good solutions in the vertical direction with few interactions on the left or right sides. This kind of dynamics is well adapted to multi-modal problems as we can reach local optima on each columns of the grid and then migrate them horizontally to find new solutions.

Performances would probably improve if the selective pressure did not remain static during the search process. As in
[1], we can define some criteria to self-adjust the anisotropy degree along generations. Furthermore, we can assign a different anisotropy degree to each cell of the grid, so that we can determinate criteria to self-adjust selective pressure locally upon measures on neighborhoods.

![0_image_0.png](0_image_0.png)

## Conclusions And Perspectives

This paper presents a new selection scheme in cellular genetic algorithms. The main objective is to control the exploration/exploitation tradeoff in a flexible way. We propose to exploit the cellular GA characteristics to promote diversity during a genetic search process. Previous studies on cGAs selected structural parameters, as neighborhood or grid shape, to tune the selective pressure. The main drawback of these techniques is that altering a structural parameter entails a deep change in the way we deal with the problem. The new selection scheme we suggest is based on fuzzy neighborhood **where a cell is chosen according to**
different probabilities. In order to favor one direction rather than the other one, anisotropic selection **chooses individuals in fuzzy neighborhood. Experiments performed in order**
to establish relation between the takeover time and the degree of anisotropy are consistent with our expectation that selection pressure decreases with the degree of anisotropy.

Analysis of the growth curves allows to distinguish three different phases in the diffusion process. Experimental results establish linear correlation in takeover between AS and cGA using rectangular grid. Then we point out capabilities of AS to promote the emergence of niches. Finally, using a cGA with AS on a QAP we have shown the existence of an anisotropic optimal value of α **such that the best average**
performance is observed.