
## Annex 1 - Logical Structure Of The Paper.

This annex presents the logical structure of the main arguments presented in this paper represented by two maps. The problem is mapped in Fig. 2. and the proposed solution in Fig. 3. For an easier back-and-forth between the paper and the maps, the blocks are numbered in the map (letters for Fig. 2, and numbers for Fig. 3) and those numbers appear in bold in the text. This approach provides an *externalization of reasoning* so that arguments can be clearly visualized. This brings many benefits, such as: 
- Allowing the reader to quickly and clearly grasp the logic of the argumentation.

- Presenting an alternative structure of the content of the paper. The table of content and the abstract tend to present a rhetorical (and not logical) structure.

- Allowing the possibility of a constructive discussion of assumptions and deductions.

For example, a critique can say "the core problem is not P but Q"; or "I disagree that hypothesis [X.XX] leads to [Y.YY], you need implicit hypothesis Z, ..." or "hypothesis [Z.ZZ] is wrong because"; or "there is another solution to your problem, which is..." etc.
It should be clear however that reading those maps can not replace the reading of the paper. Only the core reasoning is mapped, sometimes even in a simplified way. To draw those maps we used some of the insights of Eliyahu Goldratt's Theory of Constraints (TOC) and its "Thinking Process" (see Goldratt and Cox 1984; Goldratt Institute 2001; Scheinkopf 1999). The TOC is a well proven management technique widely used in finance, distribution, project management, people management, strategy, sales and marketing . We see it and use it as part of a generic problem solving toolbox, where causes and effects are mapped in a transparent way. In our paper, the core problem is: "how to make the indefinite continuation of life possible?"; and the proposed solution is that "intelligent civilization can reproduce the universe".

In this TOC framework, three fundamental questions are employed to tackle a problem:
(1) What to change? 

A core problem is identified as the *undesirable effect*, and mapped in a "Current Reality Tree" (CRT), see Fig. 2.

(2) To what to change?

A solution is proposed and mapped in a "Future Reality Tree" (FRT), which leads to the desirable effect, see Fig. 3. 

(3) How to cause the change?

A plan is developed to change from CRT to FRT. This third step in the context of this paper is even more speculative, so it is almost not developed, and thus not mapped. 