the laws of the universe have engineered their own comprehension
(Davies 1999, 146)

## Introduction

What will happen to the Earth and the Sun in the far future? The future story depicted by modern science is a gloomy one. In about 6 billion years, it will be the end of our solar system, with our Sun turning into a red giant star, making the surface of Earth much too hot for the continuation of life as we know it. The solution then appears to be easy: move. However, even if life would colonize other solar systems, there will be a progressive end of all stars in galaxies. Once stars have converted the available supply of hydrogen into heavier elements, new star formation will come to an end. In fact, the problem is worse. It is estimated that even very massive objects such as black holes will evaporate in about 1098 years (Adams and Laughlin 1997).

This scenario is commonly known as the "heat death", and says that the universe will irreversibly decay towards a state of maximum entropy **[b, d]**1. If this model is correct [c],
then it clearly means that the indefinite continuation of life is impossible in this universe [f]. What is the point of living in a universe doomed to annihilation? Ultimately, why should we try to solve mundane challenges of our daily lives and societies, if we can not even imagine a promising future for intelligent life in the universe? If we recognize this heat death **[1.12]**, then we should certainly do something to avoid it **[1.13]**, and thus try to change the future of the universe **[1.14]**. 

A few authors have proposed some speculative solutions, but we'll see that they are insufficient because none of them presently allows the indefinite continuation of intelligent life. We will instead argue that intelligent civilization will in the far future produce a new universe **[4.0]**. Although it sounds like a surprising proposition, resembling science fiction scenarios, we will consider it seriously and carefully. 

It should be noted that the proposition of involving intelligent life into the fate of the universe is at odds with traditional science. Indeed, the modern scientific worldview has often suggested that the emergence of intelligence was an accident in a universe that is completely indifferent to human concerns, goals, and values (e.g. Weinberg 1993; Stenger 2007). I thus challenge this proposition, and another one that is commonly associated with it, which says that: [a] intelligent civilization can not have a significant influence on cosmic evolution.

Our central focus is on the future of scientific simulations, and how important this activity could be in the far future, if intelligent civilization is to have influence on cosmic evolution. It is increasingly clear that simulations and computing resources are becoming main tools of scientific activity **[1.15]**. More concretely, at a smaller scale than the universe, we have already begun to produce and "play" with artificial worlds, with the practice of computer simulations. In particular, efforts in the Artificial Life (ALife) research field have shown that it is possible to create digital worlds with their own rules, depicting agents evolving in a complex manner. We will see that such simulation promise to become more and more complex and elaborated in the future. 

2