In the first part, we argue that the path towards a simulation of an entire universe is an expected outcome of our scientific simulation endeavours. We then examine how such a simulation could be realized (instantiated, made physical) and solve the irreversible heat death of the universe, expected to happen at some future time. 

## Towards A Simulation Of An Entire Universe 3

In this section, we argue that simulating open-ended evolution not only in biology, but also to link it to physical evolution (a level below) and to cultural evolution (a level above) will be a long-term outcome of our scientific simulation endeavours. Such a simulation would allow us to probe what would happen if we would "replay the tape of the universe". We then discuss in more depth the status and potential usefulness of a simulation of an entire universe, making a distinction between *real-world* and *artificial-world* modelling. We outline and criticize the "simulation hypothesis", according to which our universe has been proposed to be just a simulation. Let us first summarize the historical trend of exponential increase of computing resources.

## Increase Of Computing Resources

We may note two important transitions in the history of human culture. The first is the externalization of memory through the invention of writing. This allowed an accurate reproduction and a safeguard for knowledge. Indeed, knowledge could easily be lost and distorted in an oral tradition. The second is the *externalization of computation* through the invention of computing devices. The general purpose computer was inspired by the work of Church, Gödel, Kleene and Turing, and its formal specifications constitute the most general computing device (see Davis 2000 for a history of computation). The consequences of this last transition are arguably as significant -or even more significant- as the invention of writing. In particular, the changes induced by the introduction of computers in scientific inquiry are important, and remain underestimated and understudied (see however (Floridi 2003) for a good starting point). 

Computing resources have grown exponentially, at least for over a century. There is much literature about this subject (see e.g. Kurzweil 1999; 2006). Moore's "law" famously states that the number of transistors doubles every 18 months on a single microprocessor [1.21]. Exponential increase in processing speed and memory capacity are direct consequences of the law. What are the limits of computer simulations in the future? Although there is no Moore's law for the efficiency of our algorithms, the steady growth in raw computational power provides free "computational energy" to increase the complexity of our simulations. This should lead to longer term and more precise predictions. Apart from the computational limitation theorems (uncomputability, the computational version of Gödel's theorem proved by Turing), the only limit to this trend is the physical limit of matter or the universe itself (Lloyd 2000; Krauss and Starkman 2004). As argued by Lloyd (2000; 2005) and Kurzweil (2006, 362) it should be noted that the ultimate computing device an intelligent civilization could use in the distant future is a very dense object, i.e. a black hole [1.22]. 

From a cosmic outlook, Moore's trend is in fact part of a much more general trend which started with the birth of galaxies. The cosmologist and complexity theorist Eric Chaisson proposed a quantitative metric to characterize the dynamic (not structural) complexity of physical, biological and cultural complex systems (Chaisson 2001; 2003). It is the *free energy rate density* (noted ΦM) which is the rate at which free energy transits in a