
## Bridging Physical, Biological And Cultural Evolution 5

We saw that a metric can be found to compare complex systems traditionally considered as different in nature. This important insight is just a first step towards bridging physical, biological and cultural evolution **[1.32]**. The information-theoretic endeavours are certainly going in this direction (e.g. (Von Baeyer 2004; Prokopenko, Boschetti, and Ryan 2007; Gershenson 2007; Floridi 2003) as well as "Big History" thinkers (e.g. Christian 2004; Spier 2005). 

Artificial Life (ALife) is a field of research examining systems related to life, its processes, and its evolution through simulations using either computer models (soft ALife), robotics (strong ALife), or biochemistry (wet ALife). A general challenge for ALife is to obtain an artificial system capable of generating open-ended evolution (Bedau et al. 2000).

Some results have been obtained linking for example the evolution of language with quasibiological traits (Steels and Belpaeme 2005). Working towards the design of a digital universe simulating the rise of levels of complexity in the physical, biological and cultural realms is the challenge of simulating an entire universe **[1.16]**. An important step in this direction, although it stays on the physical level, is the "Millennium Run" simulation , which starts from the very beginning of the universe to generate the large scale structures of the universe (Springel et al. 2005).

However, we must acknowledge important difficulties of conceptual, methodological and cultural integration between the different disciplines involved. In such an endeavour, human-made social and academic boundaries between disciplines of knowledge must be overcome **[1.31]**. I proposed to construct integrative scientific worldviews (or philosophies) with systems theory, *problem solving* and *evolutionary theory* as three generic interdisciplinary approaches (Vidal 2008). There should be a seamless link between simulations in physics, biology and social sciences (culture). If this would happen, we would have the basic tools to work towards a model and a simulation of the entire universe [1.33; 2.0]. In fact the search for such bridges is obviously necessary if we want to tackle such difficult problems as the origin of life, where we aim to explain the emergence of life out of physico-chemical processes.

## Replaying The Tape Of The Universe

The biologist Stephen Jay Gould (1990) asked the famous question: "what would remain the same if the tape of life were replayed?". Paraphrasing and extending it to the universe, the question becomes: "what would remain the same if the tape of the universe were replayed?". We should first notice that the tape metaphor has its limits. Indeed, if the tape and its player were perfect, we should get exactly the same results when re-running the tape. Yet if our universe self-constructs, one question is whether small fluctuations could lead to slightly different outcomes, or very different ones if for example the system is chaotic. 

By exploring other simulated universes, this approach would allow us to face one of the main difficulties in cosmology, which is that, as far as we know, there is only one object of study: our unique universe. More precisely, two fundamental limitations of current cosmology that Ellis (2005, sec. 3) has pointed out might then be addressed:
Thesis A1: The universe itself cannot be subjected to physical experimentation. *We cannot rerun the universe with the same or altered conditions to see what would happen if they were different, so we* cannot carry out scientific experiments on the universe itself. Furthermore,