Artificial-world modelling is the endeavour to model *processes-as-they-could-be*. The formal fundamental rules of the system (of life in the case of ALife) are sought. The goal of ALife is not to model life exactly as we know it, but to decipher the most simple and general principles underlying life and to implement them in a simulation. With this approach, one can explore new, different life-like systems. Stephen Wolfram (2002) has a similar approach by exploring different rules and initial conditions on cellular automata, and observing the resulting behaviour of the system. It is legitimate to emphasize that this is a "new kind of science". Indeed, this is in sharp contrast with traditional science focusing on modelling or simulating reality. There is thus a creative aspect in the artificial-world modelling, which is why many artists have enthusiastically depicted imaginary ALife worlds. For what would an artificial-world simulation of an entire universe be useful? We would be able not only to "replay the tape of our universe", but also to play and replay the tape of *other possible* universes (thus tackling limitations A1 and A2 explicated by Ellis) **[2.1; 2.2]**. We saw that simulation constitutes a research program for tackling the fine-tuning issue in cosmology [2.3]. The concept of "a universe" then needs to be redefined and extended, since we only know by definition our unique universe. 

Should this artificial world modelling of an entire universe be interpreted as a simulation or as a *realization* (Pattee 1989)? To start, let us consider the first possibility, with the *simulation hypothesis.* 

## The Simulation Hypothesis 7

Let us assume what we have argued in the previous section, i.e. that intelligent life will indeed be able at some point to simulate an entire universe. If such a simulation is purely digital, thus pursuing the research program of soft ALife, this leads to the *simulation* hypothesis, which has two main aspects. First, looking into the future, it means that we would effectively create a whole universe simulation, as has been imagined in science fiction stories and novels such as the ones of Isaac Asimov (1956) or Greg Egan (2002). Very well then! A second possibility is that we ourselves could be part of a simulation run by a superior intelligence (e.g. Bostrom 2003; Barrow 2007; Martin 2006). Although these scenarios are fascinating, they suffer from two fundamentals problems. First, the "hardware problem" : on what physical device would such a simulation run? Is there an infinity of simulation levels?

Second, such an hypothesis violates Leibniz' logical principle of the identity of the indiscernibles. Leibniz' principle states that "if, for every property F, object x has F if and only if object y has F, then x is identical to y". Let x be reality, and y be the supposed simulated universe we would be living in. If we have no way to distinguish between them, they are identical. Unless we find a "bug" in reality, or a property F that could only exist in a simulation and not in reality, this hypothesis seems useless. A more comprehensive criticism of these discussions can be found in (McCabe 2005). 

The ontological status of this simulation would be reflected by the states of the hardware running it, whatever the realistic nature of the simulation. From this point of view, we can argue that it remains a *simulation*, and not a *realization* (Harnad 1994). Is there another possibility for realizing the simulation of an entire universe? That is what we will explore now. 