
## Towards A Realization Of An Entire Universe 8

We first outline some aspects concerning the far future of the universe. We then put forward a philosophical approach to tackle this problem, and outline a speculative solution called "artificial cosmogenesis". 

## The Heat Death Problem

We outlined in introduction the heat death problem. Consider the second law of thermodynamics which is one of the most general laws of physics. It states that the entropy of an isolated system will tend to increase over time. Hermann von Helmholtz applied it to the universe as a whole in 1854 to state the heat death (HD) problem, i.e. that the universe will irreversibly go towards a state of maximum entropy. Modern cosmology shows that there are some other models of the end of the universe (such as Big Bounce, Big Rip, Big Crunch..., see (Vaas 2006) for an up-to-date review). The point is that none of them allows the possibility of the indefinite continuation of life as we know it. The study of the end state of the universe, or *physical eschatology*, is a scattered but exciting field of research that we cannot detail more here (see (Ćirković 2003) for an extensive literature guide). 

Some speculative scenarios have been proposed to tackle this problem. They all suppose as we do in this paper that "intelligent civilization can have significant influence on cosmic evolution" **[4.1]**; but also that in the future, life will be very different as the one we know. Let us mention some of them. Dyson proposed that life and communication can continue "forever", utilizing a finite store of energy (Dyson 1979); the "final anthropic principle" put forward by Barrow and Tipler (1986) proposes that intelligent informationprocessing will never die out. Interestingly, under certain conditions, it is theoretically possible to make computing a reversible process (Bennett 1982; Landauer 1991; Krauss and Starkman 2000). If we could make this happen, this might be a way to possibly have "life" continue for an indefinite amount of time. 

These speculations are remarkable in the sense that they attempt to find ways for intelligent life to survive forever. However, they assume the additional hypothesis that life should take another "information-like" form. Krauss and Strakman (2000) showed that there are serious difficulties to the scenario proposed by Dyson. The reversible computation scenario is also not sustainable in the long run, since, as Krauss and Strakman argue, no finite system can perform an infinite number of computations with a finite amount of energy. Furthermore, these scenarios give no clear link to the increasing abilities of intelligent life to model the universe, nor do they relate to the fine-tuning problem.

In an optimistic picture, that is if our civilization does not self-destruct (or if it does, we can add the hypothesis that we are not alone in the universe...), we can see the HD problem as the longest-term problem for intelligent life in the universe. How should we react to it? Charles Darwin's thought on the HD problem remains perfectly relevant: "Believing as I do that man in the distant future will be a far more perfect creature than he now is, it is an intolerable thought that he and all other sentient beings are doomed to complete annihilation after such long-continued slow progress" (Darwin 1887, 70)