
## A Philosophical Approach For A Speculative Topic 9

Before proposing another possible solution to the HD problem, we have to make a methodological clarification. The solution proposed in the next section will be approached from a *speculative* philosophical stance, as opposed to *critical* philosophy (Broad 1924). I have proposed a general philosophical framework to rationally construct speculative theories in (Vidal 2007). We should be well aware of the difficulty of the question we are tackling; an age-old philosophical problem which is: "what is the ultimate fate of humanity and the universe in the very distant future?". This problem is philosophical because (1) we do not have unambiguous empirical or experimental support to favour a unique outcome and (2) it is such an ambitious question, that the proposed answer can only be tentative and speculative. It is however still very worth considering because the philosophical inquiry aims to advance our most profound questions here and now, whatever their difficulty and our limited knowledge. 

## Artificial Cosmogenesis

The cosmologist Lee Smolin proposed a theory called Cosmological Natural Selection
(CNS) in order to tackle the fine-tuning problem (Smolin 1992; 1997). According to this natural selection of universes theory, black holes give birth to new universes by producing the equivalent of a Big Bang, which produces a baby universe with slightly different physical properties (constants, laws). This introduces variation, while the differential success in selfreproduction of universes via their black holes provides the equivalent of natural selection.

This leads to a Darwinian evolution of universes whose properties are fine tuned for black hole generation, a prediction that can in principle be falsified. 

Smolin is not the only cosmologist reasoning with multiple universes, comprising an extended ensemble called a multiverse. Although the idea of a multiverse is a speculative one, it is increasingly popular among many cosmologists. New universes are generally theorized to appear from the inside of black holes, or from the Big Bang itself **[3.0; 3.1]**. Kuhn (2007) distinguished many kinds of multiverse models: by disconnected regions (spatial); by cycles (temporal); by sequential selection (temporal); by string theory (with minuscule extra dimensions); by large extra dimensions; by quantum branching or selection; by mathematics and even by all possibilities, whatever this may mean. Among these multiverse theories, Smolin's CNS is arguably the most scientifically testable (Smolin 2007).

It should be noted however that in Smolin's theory, (1) the roles of life and intelligence in the universe are incidental, as they are in the modern scientific worldview. Which is, let us remember, the main assumption we challenge here. Another problem is that (2) the theory does not propose a specific mechanism for the variation of universe parameters beyond the assumption of randomness. Is it possible to overcome these two shortcomings? A few authors have dared to extend CNS by including intelligent life into this picture, correcting those two problems and also bringing indirectly a possible solution to the HD problem (Crane 1994; Harrison 1995; Baláz 2005; Gardner 2000; 2003; Smart 2008). Simply stated, the thesis is that advanced intelligent civilization will solve the HD problem by reproducing the universe. This direction can be seen as the ultimate challenge of strong/wet ALife, to realize a new universe. 

Let us note however that there is not (yet) a uniform terminology among the five mentioned authors. Inspired by Smolin's terminology we could speak of a "Cosmological Artificial Selection" (CAS), artificial selection on simulated universes enhancing natural selection of real universes (Barrow 2001, 151). The biological analogy is interesting here. Humans who practice artificial selection on animals do not "design" or "create" new organisms, nor do they replace natural selection. They just try to foster some traits over others. In CNS, many generations of universes are needed to randomly generate a fine tuned