
## Abstract

In this paper, we describe a new algorithm that consists in combining an eye-tracker for minimizing the fatigue of a user during the evaluation process of Interactive Evolutionary Computation. The approach is then applied to the Interactive OneMax optimization problem. 

## Categories And Subject Descriptors

D.3.3 [Programming Languages**]: Language Contructs and** Features - **abstract data types, polymorphism, control structures.** 
I.2.10 [Artificial Intelligence]**: Vision and Scene Understanding** 
- **Perceptual reasoning** J.4 [Social And Behavioral Sciences]**: Psychology** 
General Terms Algorithms, Measurement, Experimentation, Human Factors. 

## Keywords

Interactive evolutionary computation, user fatigue minimization, eye-tracking system, interactive one-max problem. 

## 1. **Introduction**

Interactive Evolutionary Computation (IEC) often suffers from user fatigue. In this paper, we present a new technique, totally independent of the domain used, to minimize this fatigue by combining an IEC and an input device. This device allows capturing where the user is looking on a monitor on which individuals are presented. This is possible by using eye-tracking systems such as Tobii **which are totally non-intrusive for the** 
user. Thus, we ensure there is no need for explicit user action (choosing and clicking the most promising individual, evaluating all the solutions etc.) during the evaluation process of the IEC; he just has to watch the screen and the presented individuals and to tell when he has finished evaluating/looking. The evolutionary algorithm then determines automatically which presented individuals are better by combining parameters obtained by a Tobii **for each presented individual. We have applied to the** 
Interactive One-Max problem [3]. Thus, by using totally implicit evaluation, we minimize the fatigue of the user in interactive computation, independently of the problem to be optimized. This approach may be used in any computer graphics application in which optimization or decision making is used. 

In this paper, we first present related work in Interactive Evolutionary Computation, as well as an eye-tracking system and how it can be used with evolutionary algorithms. Next, we present 

Eye-Tracking Evolutionary Algorithm to minimize user 

fatigue in IEC applied to Interactive One-Max problem 

Denis PALLEZ 

LIRIS Lab 

University of Lyon1 

Lyon - France 

denis.pallez 

@unice.fr 

the application we have developed to simulate this approach (Interactive One-max problem). We finish by presenting some results and future work. 

| Thierry BACCINO  LPEQ Lab  University of Nice  Nice - France  thierry.baccino  @unice.fr   | Laurent DUMERCY  LPEQ Lab  University of Nice  Nice - France  laurent.dumercy  @unice.fr   |
|--------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------|

| LIRIS Lab                                                      |         |
|----------------------------------------------------------------|---------|
| University of Lyon1  Lyon - France  denis.pallez  @unice.fr    | I3S Lab |
| University of Nice  Nice - France  philippe.collard  @unice.fr |         |

## 2. **Iec Related Work**

IEC is an optimization technique based on evolutionary computation (genetic algorithm, genetic programming, evolution strategy, or evolutionary programming) and used when it is hard or impossible to formalize efficiently the fitness function (the method that gives the performance of a solution to a given problem) and where the fitness function is therefore replaced by a human user. For instance, IEC is often used for optimization of subjective criteria such as aesthetics. A large survey of more than 250 papers can be obtained in [16], but the generally accepted first work on IEC is Dawkins [5], who studied the evolution of creatures called "biomorphs" by selecting them manually. 

Subsequently, much work was done in the area of computer graphics: for instance using IEC for optimizing lighting conditions for a given impression [1], applied to fashion design [9], or transforming drawing sketches into 3D models represented by superquadric functions and implicit surfaces, and evolving them by using divergence operators (bending, twisting, shearing, tapering) to modify the input drawing in order to converge to more satisfactory 3D pieces [12]. We can also mention work in combining human interactions with an artificial ant, applied to non-photorealistic rendering [15]. Another use of IEC involves a human patient using a PDA on which an IEC is launched to define best parameter values for cochlear implants [2]. First results show that patients using PDAs obtain a better parameterization than previously through lengthy interaction with a doctor. Following the same idea of using other human senses for human interaction, we can also mention the optimization of coffee blends [7]. As mentioned before, IEC is used when a fitness function is difficult and sometimes impossible to formalize. Human-Based Genetic Algorithms (HBGA) go further by allowing evolutionary computation where a good representation of individuals is hard or impossible to find [3], for instance they can be used in storytelling or in development of marketing slogans. To prove the usefulness of such techniques, the authors changed the classical One-Max optimization problem into an interactive one by interpreting the individuals (strings of bits - 0 or 1) as colors to be interactively presented and manipulated. We use the same approach to test our proposition. Characteristics of IEC are inconsistencies **of individuals fitness** values given by the user, slowness **of the evolutionary** 
computation due to the interactivity, and fatigue of the user due to 