the obligation to evaluate manually all the individuals of each generation [14, 16]. For instance, most often the user is asked to give a mark to each individual or to select the most promising individuals according: it still requires active time consuming participation during the interaction. The number of individuals of a classical IEC is about 20 (the maximum that can be represented on the screen), and about the same for the number of generations. 

However, some tricks are used to overcome those limits, e.g., 
trying to accelerate the convergence of IEC by showing the fitness landscape mapped in 2D or 3D, and by asking the user to determine where the IEC should search for a better optimum [6]. Other work tries to predict fitness values of new individuals based on previous subjective evaluation. This can be done either by constructing and approaching the subjective fitness function of the user by using genetic programming [4] or neural networks, or also with Support Vector Machine [10, 11]. In the latter case, inconsistent responses can also be detected thanks to graph based modeling. 

Nonetheless, previous work is mostly algorithmic-oriented and not really user-oriented, which seems to be the future domain for IEC [13, 16]. In the next section, we will present material that can be combined with Interactive Evolutionary Computation in order to significantly reduce the active participation of the user during the evaluation process and to consequently reduce considerably the fatigue of the user and the slowness of IEC approaches. 

## 3. **Eye-Tracking Evolutionary** Algorithm (E-Tea) 3.1 **What Is An Eye-Tracking System?**

An eye-tracking system consists of following the eye's motions while a user watches a screen on which something is presented. It pinpoints in real time the position where the eye is looking, with the help of one or two video cameras focusing on a reflected infrared ray sent to the user's cornea (cf. Figure 1). This device coupled with a computer regularly samples the space position of the eye and the pupil diameter. This latter parameter lets us know the cognitive intensity of the user: the more the user is concentrated on looking at something, the smaller the diameter [8]. Nowadays, eye-tracking systems are very useful because they can analyze in real time what a user is focused on without any effort and in a completely non-restrictive manner, in fact, the user does not know he is being observed by the machine. With such equipment, one can finally capture when, how much time, and with which cognitive intensity a screen area is looked at. 

## 3.2 **How To Use An Eye-Tracker In Iec?**

If we consider that either phenotype or genotype of individuals are graphically displayable on a screen, we can easily envisage using an eye-tracker during the evaluation process of IEC. Our proposal consists in using this hypothesis: the more an individual is examined, the better the fitness of this particular individual will be. So, a new evolutionary algorithm called Eye-Tracking Evolutionary Algorithm (E-TEA) is proposed: 
1. **generate initial population;** 
2. **present the population to the user;** 
3. **let the user watch the individuals** 

![0_image_0.png](0_image_0.png)

Figure 1: How works an eye-tracker like Tobii ?
4. **compute how much time, how many times and with** 
which cognitive intensity the presented individuals are looked at thanks to an eye-tracker; 5. **combine previously obtained parameters and compute a** 
fitness for each individual; 6. **select the most promising individuals from the** 
computed fitness 7. **make crossover and mutation** 
8. **return to step 2 until no further good individuals are** 
found Thus, the user just has to watch the screen and say when he has finished watching/evaluating. There is no need for the user to mark each individual, nor to choose the best or the most promising one. This will save considerable time and the user will be capable evaluating more solutions consequently there will be more evaluated generations. At a minimum, we estimate to double the number of generations. The principal difficulty is to determine how to combine different parameters obtained by the eye-tracker in order to define a computable fitness. 

## 3.3 **Estimated Fitness Formalization** As Seen In Previous Sections, An Eye-Tracker Like Tobii **Is Able To**

provide at least 3 parameters for a screen region: 
- let d **be the time the user has focused on a screen region;** 
- let t **be the number of transitions towards a particular screen** 
region; 
- let p **be the average of the pupil diameter when the user has** 
focused on a screen region. 

If we consider a screen region as an individual and if we suppose that the more an individual is observed, the better will be its fitness, we can define an estimated fitness of the region as: 
(1) f d t p u = α + β + γ ˆ
Unfortunately, α, β, γ **values have to be defined empirically. In** 
order to verify our hypothesis, we have conducted some experiments. 

## 4. **Application To The Interactive** One-Max Optimization Problem

Our optimization problem will be borrowed from [3] where the One-Max problem is considered as an interactive optimization problem in order to compare Interactive Genetic Algorithm (IGA) and Human-Based Genetic Algorithm (HBGA), and also in order to demonstrate the advantages of using HBGA. Recall that the 