classical One-Max optimization problem consists in maximizing the number of 1s in a string of bits (0 or 1). It is the simplest optimization problem and it is used here in order to parameterize our system. In the next paragraph, we will verify whether one-max optimization could be adapted to RGB colors. Then we present our interactive one-max problem. 

## 4.1 **One-Max Optimization Vs. Color** Optimization

In this section, we try to show that one-max optimization is rather equivalent to white color optimization in the RGB model even if it is not the best choice. Three distances for an objective fitness have been proposed [3]: 
(2) M1
(R,G, B) = R + G + B

(3) $\frac{1}{2}$
(3) M 2
$$M_{2}(R,G,B)=255\times{\sqrt{3}}-1$$
$\downarrow$ . 
(255 - R)${}^{2}$ + (255 - G)${}^{2}$ + (255 - B)${}^{2}$

## (4) M (R,G, B) **Min(**R,G, B) S =

We have studied the fitness-distance-correlation between each of the previous distances and the Hamming distance (number of 1s in the string). With 4000 samples, we found that FDC(M1) ≈ -
0.59, FDC(M2) ≈ -0.57 and FDC(MS) ≈ **-0.48. This means that** 
M1, representing the brightness, or M2**, representing the Euclidean** 
distance between the considered and the white colors, are both correlated. Thus, one-max optimization can be adapted to interactive optimization by choosing the brighter color. 

## 4.2 **Implementation**

As an eye-tracker is still very expensive, we have simulated such equipment with the help of a mouse. In fact, we ask the user to move the mouse to where he is looking. We know this is tedious, but it is the only way to simulate a Tobii**. Unfortunately, it is** 
impossible to obtain values of the third parameter p**. However, we** 
think it is not unreasonable as a test. With this restriction, we have developed an application in Java 1.6 based on the ECJ library1. 

Rather than optimizing the simple one-max problem, we have decided to show individuals as colors [3]. Individuals are represented by a string of 24 bits, 8 bits each for red, green and blue. As we capture simulated eye motion, the screen presents only 8 zones (one individual per zone) and no individual in the center of the screen as shown in Figure 2. We avoid presenting solutions in the center because eyes are naturally attracted to the center. Also, if the user wants to compare two solutions that are diametrically opposite, eyes are obliged to cross the center. 

Consequently, the number of transitions for the center will increase considerably and will disrupt the estimated fitness of the solution which could be in the center. When the user estimates he has finished watching solutions of a generation, we give him the possibility to click on his preferred color among the 8 presented. In that case, the estimated fitness is empirically cubed. The user also has the possibility to choose none of them. Thus, in Figure 2, we can see that during only the first 9 iterations colors are converging towards brighter colors. 

Consequently, the estimated fitness we used for the j th **individual** 
depends whether the user has chosen it and is defined as: 

$$\hat{f}_{u}(j)=\text{\emph{chosen?}}\sqrt{\frac{\frac{t_{j}}{2\sum_{i=1,\,s}t_{i}}+\frac{d_{j}}{2\sum_{i=1,\,s}d_{i}}}{\sum_{i=1,\,s}t_{i}}}\cdot\frac{t_{j}}{2\sum_{i=1,\,s}t_{i}}+\frac{d_{j}}{2\sum_{i=1,\,s}d_{i}}}$$  Equation (5) is equivalent to equation (1) but we have 
normalized u f ˆ in [0,1]. If solution j **is chosen, the first term is** 
used, otherwise the second term. 

## 4.3 **Results**

For the moment, it is difficult to give significantly quantitative results in so far as the application developed is only restricted to the use of a mouse and movements the user would give to it in order to simulate an eye-tracker. It is tedious work, but, we can say that it is easier to only move the mouse than to choose and click on the most promising individuals, or to evaluate them. In the future, it should be faster because interactions would be only with the eyes of the user. We estimate doubling, at a minimum the number of iterations in the Interactive Evolutionary Computation exploring a larger search space. 

## 5. **Discussions**

The Eye-Tracking Evolutionary Algorithm is a very simple but very innovative proposition that is at the intersection of two different domains: computer and cognitive sciences. This approach presents many advantages: 
- **First, it is the first time that an eye-tracker takes a very active** 
part in a computer application. More traditionally, eyetracking systems are used for analyzing human behavior when looking at an image, a text, a 3D model, a webpage, etc. 

- **Second, with such a combination we automate interactive** 
evaluation of individuals with no constraints for the user. The only thing he has to do is to watch individuals and to say when he has finished. There is no explicit task imposed on the user, and thus no additional fatigue. 

- **Next, such material is completely non-intrusive, i.e., the user** 
could forget that he is being observed. Interactive evaluation is as natural as possible. 

- **Finally, by analyzing the cognitive activity of the user, we** 
can easily detect when the user shows signs of fatigue. For 

![0_image_0.png](0_image_0.png)

