instance, when the number of transitions between individuals is seriously decreasing or when the total time used to watch a generation is also decreasing, there is a chance that the user is bored. A pause can be made and the interactive evolutionary algorithm can be resumed later. However, the time used to watch individuals could be interpreted differently: the user is quickly converging toward a very good solution. More research has to be done to detect this fatigue. 

Of course, each new system has its drawbacks, but they are few compared to the advantages: 
- **The eye-tracker can follow eyes if and only if it has been** 
calibrated to the user. However, this takes only few seconds, and the user just has to focus on concentric moving circles. 

- **The other small constraint is that the user does not have total** 
freedom of head movement. For instance, he can not look away and then resume evaluating. However, the freedom is large enough (30x16x20 cm) because of the use of two video cameras. If the signal is lost for one eye, the eye-tracker uses the other eye. 

## 6. **Conclusion & Future Work**

In this article, we have presented a new algorithm that should considerably improve the speed of Interactive Evolutionary Computation. To do so, we have presented the Eye-Tracking Evolutionary Algorithm (E-TEA) that uses an eye-tracker in order to minimize user interaction for evaluating individuals. We have tested the approach by simulating an eye-tracker with a mouse during an interactive one-max optimization problem. The user had to move the mouse exactly to where he is interested by an individual. The only difference with a real eye-tracker is the loss of crucial information about cognitive intensity represented by the pupil diameter. Nonetheless, we are convinced that time taken during the evaluation process can be significantly reduced. 

In the future, we will first create an application interfacing the interactive one-max problem and a real eye-tracker in order to correctly parameterize our interactive evolutionary algorithm. 

Next, we want to test it on a real world application. 

## 7. **Acknowledgments**

We would like to thank the Institute of Technology at Nice University (http://www.iut-nice.fr) which let this research work be possible and also to thank Pr. Peter Sander for his precious help. 

## 8. **References**

[1] Aoki K, Takagi H. 3-D CG lighting with an interactive GA. 

1st International Conference Conventional and KnowledgeBased Intelligent Electronic Systems**. Adelaide, Australia** 
1997:296-301. 

[2] Bourgeois-Republique C, Valigiani G, Collet P. An Interactive Evolutionary Algorithm for Cochlear Implant Fitting: First Results. In: al. HHe, ed. **SAC05, ACM** 
Symposium on Applied Computing**. Santa Fe, New Mexico** 2005. 

[3] Cheng CD, Kosorukoff A. Interactive One-Max Problem Allows to Compare the Performance of Interactive and Human-Based Genetic Algorithms. **Genetic and** 
Evolutionary Computation (GECCO)**. Seattle, Washington,** USA 2004:983-94. 

[4] Costelloe D, Ryan C. Genetic Programming for Subjective Fitness Function Identification. In: LNCS, ed. **Genetic** 
Programming **2004:259-68.** 
[5] Dawkins R. The Blind Watchmaker 1986. [6] Hayashida N, Takagi H. Acceleration of EC convergence with landscape visualization and human intervention. **Applied** 
Soft Computing. 2002;1**:245.** 
[7] Herdy M. Evolutionary optimization based on subjective selection - Evolving blends of coffee. **5th European** 
Congress on Intelligent Techniques and soft computing 1997:640-4. 

[8] Just MA, Carpenter PA. The intensity dimension of thought: 
Pupillometric indices of sentence processing. **Canadian** 
Journal of Experimental Psychology, Special Issue: Reading and language processing. 1993;47**:310-39.** 
[9] Kim H-S, Cho S-B. Application of interactive genetic algorithm to fashion design. **Engineering Applications of** Artificial Intelligence. 2000;13**:635.** 
[10] Llorà X, Sastry K. Combating User Fatigue in iGAs: Partial Ordering, Support Vector Machines and Synthetic Fitness. 

GECCO**. Washington, D.C., USA 2005:1363 - 70.** 
[11] Llorà X, Sastry K, Alias F. Analyzing Active Interactive Genetic Algorithms using Visual Analytics. **Genetic and** 
Evolutionary Computation (GECCO)**. Seattle, Washington,** 
USA 2006:1417-8. 

[12] Nishino H, Takagi H, Saga S, Utsumiya K. A virtual modeling system for intuitive 3D shape conceptualization. IEEE International Conference on Systems, Man and Cybernetics **2002.** 
[13] Parmee I. http://www.ad-comtech.co.uk/Workshops.htm
(accessed Date 2007). 

[14] Semet Y. Interactive Evolutionary Computation: a survey of existing theory. University of Illinois 2002. 

[15] Semet Y, O'Reilly U-M, Durand F. An Interactive Artificial Ant Approach to Non-photorealistic Rendering. **Genetic and** 
Evolutionary Computation (GECCO)**. Seattle, Washington,** 
USA 2004:188-200. 

[16] Takagi H. Interactive Evolutionary Computation: Fusion of the Capacities of EC Optimization and Human Evaluation. 

IEEE 2001:1275-96. 