# Node Discovery In A Networked Organization

Yoshiharu Maeno Social Design Group Bunkyo-ku, Tokyo 112-0011, Japan.

maeno.yoshiharu@socialdesigngroup.com Abstract—In this paper, I present a method to solve a node discovery problem in a networked organization. Covert nodes refer to the nodes which are not observable directly. They affect social interactions, but do not appear in the surveillance logs which record the participants of the social interactions. Discovering the covert nodes is defined as identifying the suspicious logs where the covert nodes would appear if the covert nodes became overt. A mathematical model is developed for the maximal likelihood estimation of the network behind the social interactions and for the identification of the suspicious logs. Precision, recall, and F measure characteristics are demonstrated with the dataset generated from a real organization and the computationally synthesized datasets. The performance is close to the theoretical limit for any covert nodes in the networks of any topologies and sizes if the ratio of the number of observation to the number of possible communication patterns is large.

Index Terms**—Anomaly detection, Covert node, Maximal likelihood estimation, Node discovery, Social network.**

## I. Introduction

Covert nodes in a networked organization refer to persons who affect social interactions (communications among the nodes and resulting collaborative activities), but do not appear in the surveillance logs which record the participants of the social interactions. They are not observable directly. Discovering the covert nodes is defined as identifying the suspicious surveillance logs where the covert nodes would appear if the covert nodes became overt. This problem is called a node discovery problem.

Where do we encounter such a problem? Globally networked clandestine organizations such as terrorists, criminals, or drug smugglers are great threat to the civilized societies. Terrorism attacks cause great economic, social and environmental damage. Active non-routine responses to the attacks are necessary as well as the damage recovery management. The short-term target of the responses is the arrest of the perpetrators. The long-term target of the responses is identifying and dismantling the covert organizational foundation which raises, encourages, and helps the perpetrators. The threat will be mitigated and eliminated by discovering covert leaders and critical conspirators of the clandestine organizations. The difficulty of such discovery lies in the limited capability of surveillance. Information on the leaders and critical conspirators are missing because it is usually hidden by the organization intentionally.

In this paper, I present a method to solve the node discovery problem. The method infers the network topology and probability parameters behind the social interactions (by use of the maximal likelihood estimation), applies an anomaly detection technique to the surveillance logs, and identifies the suspicious surveillance logs. III presents the method. IV introduces the dataset generated from a real organization and the computationally synthesized datasets for performance tests. V demonstrates the precision, recall, and F measure characteristics with the datasets.

## Ii. Relatedwork

The social network analysis is a study of social structures made of nodes which are linked by one or more specific types of relationship. Examples of the relationship are influence transmission in communication, or presence of trust in collaboration. Studies in complex networks [3], [24], [6], WWW
search and analysis [4], [1], and machine learning of latent variables [21], [22] are major related research topics.

Research interests have been moving from describing organizational nature to discovering unknown phenomena. A link discovery predicts the existence of an unknown link between two nodes from the information on the known attributes of the nodes and the known links [5], [7], [23]. The link discovery techniques are combined with domain-specific heuristics. The collaboration between scientists can be predicted from the published co-authorship [12]. The friendship between people is inferred from the information available on their web pages [2]. Discovery of a network structure [18], [16], [17] and detection of an anomaly in a network [20] are also relevant related research topics.

A node discovery predicts the existence of an unknown node around the known nodes from the information on the collective behavior of the network. Related works in the node discovery is limited. Heuristic method for node discovery is proposed in [13]. The method applies clustering algorithm [25], [8] to the nodes in a network, and detects the node which inter-connects clusters at the border of a cluster in clustered networks. The method is applied to analyze the covert social network foundation behind the terrorism disasters [14].

## A. Observation Iii. Method

A node and a link in a social network are a person and a relationship resulting in influence transmission between persons. The symbolsnj(j = 0,1, **· · ·**) represent the nodes.

Some nodes are overt (observable), but the others are covert
(unobservable).O denote a set of the whole overt nodes
{n0, n1, · · · , nN−1}. Its cardinality isN= |O|.C=O
denotes a set of the whole covert nodes{nN , nN+1, **· · · }**. The symbolδi (0≤ **i < D**) represent an individual communication arXiv:0803.3363v2 [cs.AI] 26 Jun 2009