

![0_image_0.png](0_image_0.png)

## Vi. Conclusion

In this paper, I define a node discovery problem in a networked organization and present a method to solve the problem. The method infers the network behind the social interactions, applies an anomaly detection technique to the surveillance logs, and identifies the suspicious surveillance logs. The precision, recall, and F measure characteristics are close to the theoretical limit for any covert nodes in the networks of any topologies and sizes. I believe that, in the investigation of a clandestine organization [14], the method aids the investigators in identifying the close associates (participants in the most suspicious surveillance record) of a covert leader or a critical conspirator.

I plan to address 3 issues for the future works. The first issue is to overcome the restriction where the performance degrades unless the ratio of the number of the observation to the number of possible communication patterns is large. The second issue is to extend the models for the social interactions. The model in this paper represents the radial influence transmission from an initiating node toward multiple responder nodes. In real networked organizations, other types of influence transmission are present such as serial (chain-shaped) influence transmission, or tree-like influence transmission. The third issue is to develop a method to solve the variants of the node discovery problem. Discovering fake nodes, or spoofing nodes are also interesting problems to uncover the malicious intentions of the organization. A fake node is the person who does not exist in the organization, but appears in the surveillance. A spoofing node is the person who belong to an organization, but appears as a different node in the surveillance.

We encounter the node discovery problem in many areas of business and social sciences [15]. For example, in document analysis [23], something unknown, which is not stated explicitly, can be discovered. The discovery may provide the analyst with a clue to approach the hidden intention of the author, an opinion which is about to emerge, or a sign of trends. The method will be the new basis to analyze something hidden behind the direct observation, which is beyond the scope of the conventional statistical methods and data mining expertises.

REFERENCES
[1] L. A. Adamic, R. M. Lukose, A. R. Puniyani, and B. Huberman, Search in power-law networks, Physical Review E vol. 64, 046135, 2001.

[2] L. A. Adamic, and E. Adar, Friends and neighbors on the web, Social Networks vol. 25, pp. 211-228, 2003.

[3] A. L. Barab´asi, R. Albert, and H. Jeong, Mean-field theory for scale-free random networks, *Physica A* vol. 272, pp. 173-187, 1999.

[4] M. Chau, and H. Chen, Incorporating web analysis into neural networks:
an example in hopfield net searching, IEEE Transactions on Systems, Man, & Cybernetics Part C vol. 37, pp. 352-358, 2007.

[5] A. Clauset, C. Moore, and M. E. J. Newman: Hierarchical structure and the prediction of missing links in networks, *Nature* vol. 453, pp. 98-100, 2008.

[6] P. Erd¨os, and A. R´eny, On random graphs. I., *Publicationes Mathematicae* vol. 6, pp. 290-297, 1959.

[7] L. Getoor, and C. P. Diehl, Link mining: a survey, *ACM SIGKDD*
Explorations vol. 7, pp. 3-12, 2005.

[8] T. Hastie, R. Tibshirani, and J. Friedman, The elements of statistical learning - Data mining, inference, and prediction. Springer-Verlag, 2001.

[9] P. S. Keila, and D. B. Skillicorn, Structure in the Enron email dataset, Journal of Computational & Mathematical Organization Theory vol. 11, pp. 183-199, 2006.

[10] R. R. Korfhuge, *Information storage and retrieval*. Wiley, 1997.

[11] N. Lavra˘c, P. Ljubi˘c, T. Urban˘ci˘c, G. Papa, M. Jermol, and S. Bollhalter, Trust modeling for networked organizations using reputation and collaboration estimates, *IEEE Transactions on Systems, Man, & Cybernetics Part* C vol. 37, pp. 429-439, 2007.

[12] D. Liben-Nowell, and J. Kleinberg, The link prediction problem for social networks, *Journal of American Society of Information Science and* Technology vol. 58, pp.1019-1031, 2007.

[13] Y. Maeno, and Y. Ohsawa, Human-computer interactive annealing for discovering invisible dark events, *IEEE Transactions on Industrial Electronics* vol. 54, pp. 1184-1192, 2007.

[14] Y. Maeno, and Y. Ohsawa, Analyzing covert social network foundation behind terrorism disaster, *International Journal of Services Sciences* vol. 2, pp. 125-141, 2009.

[15] Y. Maeno, and Y. Ohsawa, Reflective visualization and verbalization of unconscious preference, in press, *International Journal of Advanced Intelligence Paradigms*, 2009. Available e-print http://arxiv.org/abs/0803.4074.

[16] M. E. J. Newman, and E. A. Leicht: Mixture models and exploratory analysis in networks, *Proceedings of the National Academy of Sciences* USA vol. 104, pp. 9564-9569, 2007.

[17] G. Palla, I. Der`enyi, I Farkas, and T. Vicsek: Uncovering the overlapping community structure of complex networks in nature and society, *Nature* vol. 435, pp. 814-818, 2005.

[18] M. G. Rabbat, M. A. T. Figueiredo, and R. D. Nowak: Network Inference from co-occurrences, *IEEE Transactions on Information Theory* vol. 54, pp. 4053-4068, 2008.

[19] M. Sageman, *Understanding terror networks*. University of Pennsylvania Press, 2004.

[20] J. Silva, and R. Willett: Hypergraph-based anomaly detection of highdimensional co-occurrences, IEEE Transactions on Pattern Analysis and Machine Intelligence vol. 31, pp. 563-569, 2009.

[21] R. Silva, R. Scheines, C. Glymour, and P. Spirtes, Learning the structure of linear latent variable models, *Journal of Machine Learning Research* vol. 7, pp. 191-246, 2006.

[22] S. Singh, J. Allanach, T. Haiying, K. Pattipati, and P. Willett, Stochastic modeling of a terrorist event via the ASAM system, in *Proceedings of the* IEEE International Conference on Systems, Man & Cybernetics, Hague, 2004.

[23] B. Taskar, M. F. Wong, P. Abbeel, and D. Koller, Link prediction in relational data, in *Proceedings of the Neural Information Processing* Systems Conference, Vancouver, 2003.

[24] D. J. Watts, and S. H. Strogatz, Collective dynamics of small-world networks, *Nature* vol. 398, pp. 440-442, 1998.

[25] A. Zakarian, A new nonbinary matrix clustering algorithm for development of system architectures, *IEEE Transactions on Systems, Man, &*
Cybernetics Part C vol. 38, pp. 135-141, 2008.