
## 4 Conclusion

For this paper, we developed a method that helps people become aware of their unconscious preferences and convey them to others in the form of verbal explanation. The method combines the concepts of reflection, visualization
(with an algorithm to draw the subjects' stated preferences in a diagram), and verbalization (through group discussion). The method was tested in an experiment where the unconscious preferences of the subjects for various artworks were investigated.

In the experiment, two lessons were learned. The first is that it helps the subjects become aware of their unconscious preferences to verbalize weak preferences as compared with strong preferences through discussion over preference diagrams. The second is that it is effective to introduce an adjustable factor into visualization, such as the granularity of the preference diagram, to adapt to the differences in the subjects and to foster their mutual understanding. The lessons imply that the interpretation of the weak preferences, which emerged in the reflection process, is subject to the particular nature of the **presented artworks and the subjects joining the** discussion. The questionnaire may also affect the subjects. Which artwork is suitable for your room? Which artwork would you like to buy? These two questions may cause different responses from the subjects. Preferences may also be influenced by a change in the environment. The individual's unconscious tendency itself may change by the individual becoming aware of its presence. Such sensitivity is essential to modern consumer behavior. It is beneficial to focus on such case-by-case preferences rather **than to make an effort to figure out the universal** laws of human behavior.

Unconscious preference is one of the factors in stimulating brand switching in marketing or extending belonging groups in communication. We have taken the first step toward understanding individuals' unconscious tendencies in thinking and acting. Our method stimulates the existing unconscious tendency in order to prompt change. The method, which exploits the delicate nature of the unconscious preference, is essential in the future of marketing, education, communication, and many other applications.

## References

[Arora 1998] N. Arora, G. M. Allenby, and J. L. Ginter: A hierarchical Bayes model of primary and secondary demand, Marketing Science 17**, 29-44 (1998).**
[Cheung 2004] K. W. Cheung, K. C. Tsui, and J. Liu: Extended latent class models for collaborative recommendation, IEEE Transactions on Systems, Man, & Cybernetics Part A 34**, 143-148 (2004).**
[Clauset 2008] A. Clauset, C. Moore, and M. E. J. Newman: Hierarchical structure and the prediction of missing links in networks, Nature 453**, 98-100 (2008).**
[Dempster 1977] A. Dempster: Maximum likelihood from incomplete data via the EM algorithm, Journal of the Royal Statistics Society B39**, 1-38 (1977).**
[Duda 2000] R. O. Duda, P. E. Hart, and D. G. Stork: Pattern classification. Wiley-Interscience (2000).

[Fruchterman 1991] T. M. J. Fruchterman and E. M. Reingold: Graph drawing by force-directed placement, Software - Practice and Experience 18**, 1129-1164 (1991).**
[Green 1981] P. Green, J. Carroll, and S. Goldberg: A general approach to product design optimization via conjoint analysis, Journal of Marketing 43**, 17-37 (1981).**
[Hastie 2001] T. Hastie, R. Tibshirani, and J. Friedman: The elements **of statistical learning: Data mining,**
inference, and prediction. Springer-Verlag (2001).

[Ishii 2002] N. Ishii, and K. Miwa: Interactive processes between mental and external operations in creative activity: A comparison of experts' and novices' performance, in Proceedings of the Creativity and Cognition Conference, Loughborough (2002).

[Krebs 2002] V. E. Krebs: Mapping networks of terrorist cells, Connections 24**, 43-52 (2002).**
[Larkin 1987] J. Larkin, and H. A. Simon: Why a diagram is (sometimes) **worth ten thousand words?, Cognitive**
Science 11**, 65-99 (1987).**
[Liben-Nowell 2007] D. Liben-Nowell, and J. Kleinberg: The link prediction problem for social networks, Journal of American Society of Information Science and Technology 58**, 1019-1031 (2007).**