Reflection in cognitive science [Sch¨on 2006] and computer-mediated communication [Thurlow 2004] are theoretical guides to approach unconscious preferences. The abilities to recognize and understand oneself, discover something unexpected, and create something new are founded on constructive perception [Suwa 2002],
[Suwa 2003]. Constructive perception is the ability to perceive the visual characteristics of elements, the relationships between the elements, and the empty relevant space between the elements in diagrams, sketches, or drawings [Larkin 1987]. Visualization and verbalization play important roles in becoming aware of a person's present perception, and in changing it. Perception is a process used to interpret sensory signals from the outside. For example, drawing for reflection, which records a designer's daily **intermediate outcomes, was proven to be an**
effective tool in a university education program of creativity [Ishii **2002]. A practical tool based on the theory of** constructive perception is needed, like the drawings for designers, which can help a person's reflective visualization and verbalization of that person's unconscious preferences.

Methods of discovery in other fields can be applied to the discovery of unconscious preference. For example, in social network analysis, a heuristic method was developed to solve a **node discovery problem. Its aim is to discover** an unknown relevant person hidden in a criminal organization [Krebs 2002]. The person is not found in the records of observed actions but plays a relevant role in organizational communication and decision-making [Maeno 2009]. The method is implemented as an iterative process where the discrepancy between prior understanding and observation is indicated in the form of a social network diagram [Maeno 2007b]. Other methods of discovery are link prediction [Clauset 2008], discovery of hierarchies [Sales-Pardo 2007], cluster discovery [Palla 2005], and exploration of unknown structures [Newman 2007]. Incorporating insights from the cognitive sciences would help to develop such a discovery process for treating unconscious preferences.

The objective of this paper is to develop a method that can help a person become aware of his or her unconscious preferences. The method combines the concepts of **reflection, visualization (with an algorithm to** draw the subject's stated preference in a diagram), and verbalization (through group discussion). The method is described in section 2 (with the preference diagram in 2.1, the visualization algorithm in 2.2, and the reflection process in 2.3). The experiment of testing the reflection process to investigate the unconscious preferences of subjects with artwork and the lessons learned from it are presented in section 3.

## 2 Method 2.1 Preference Diagram

A preference diagram is a practical tool that can be used to promote the reflective visualization and verbalization of unconscious preferences. It also aids in efficient communication and mutual understanding in group discussion.

The preference diagram is a kind of undirected graph consisting of nodes and undirected links drawn on a plane.

A node represents either the i-th subject nPIDi or the j-th artwork nj **. A link represents either the resemblance**
relationship between two artworks or the preference relationship **of a subject to an artwork. The topology defined** by the presence of links is relevant. The position of the nodes and the distance between the nodes on the diagram, however, are not relevant. Figure 1 [a] shows an example.

The preference diagram is designed so that the cluster structures are clearly visible. For an individual subject nPIDi**, four characteristic objects are selected as attributes describing the subject's preferences. The objects are**
the primary cluster cPRM(nPIDi), the gateway artwork in the primary cluster nGTW|PRM(nPIDi**), the secondary** cluster cSCN(nPIDi), and the gateway artwork in the secondary cluster nGTW|SCN(nPIDi**). The primary cluster**
represents the cluster whose artworks are preferred by a subject most strongly. The secondary cluster is the cluster whose artworks are preferred most weakly. The gateway **artwork indicates a subject's preferable entrance**
point to the cluster. Note that the primary cluster for a subject can be the secondary cluster for another subject. The labels for the characteristic objects are not drawn on the diagram. There may be multiple gateway artworks.

The preference diagram includes another interesting object. A switch object nSWTi for a subject nPIDiis inserted into the space between the primary and secondary clusters. The switch is assumed to change the mode of the subject's preference. The switch tends to point to the primary cluster most of the time, although it sometimes points to the secondary cluster. The switching occurs either from internal caprice or from an external stimulus such as atmosphere, influence from friends, or social interaction. The switch indicates the presence of an unknown factor that prompts the subjects to turn their interests toward something unfamiliar. This is the clue to unconscious preferences. Figure 1 [b] shows an example of the four characteristic objects and the switch object for a subject person n**PID1**.