# Agent-Based Perception Of An Environment In An Emergency Situation Fahem Kebair, Fr´Ed´Eric Serin And Cyrille Bertelle ∗

Abstract**—We are interested in the problem of multiagent systems development for risk detecting and**
emergency response in an uncertain and partially perceived environment. The evaluation of the current situation passes by three stages inside the multiagent system. In a first time, the situation is represented in a dynamic way. The second step, consists to characterise the situation and finally, it is compared with other similar known situations. In this paper, we present an information modelling of an observed environment, that we have applied on the RoboCupRescue Simulation System. Information coming from the environment are formatted according to a taxonomy and using semantic features. The latter are defined thanks to a fine ontology of the domain and are managed by factual agents that aim to represent dynamically the current situation.

Keywords: Factual agent, Multiagent system, Ontology, Semantic feature, Taxonomy

## 1 Introduction

Recent catastrophic disasters have brought urgent needs for diverse technologies for disaster relief. Currently, there is an overwhelming need for better information technology to help support the efficient and the effective management of the disaster management (also known as emergency response). In particular, actors and agencies need an assistance to help them to make a decision in a fashion time and to be able to coordinate their efforts in a flexible way in order to prevent further problems or effectively manage the aftermath of a disaster. Our project is situated in this context and consists to develop a generic Decision Support System (DSS), able to detect a risk in an uncertain and partially perceived environment and to prevent its evolution. The DSS kernel is a multiagent system with three layers, where each one has a specific role. The role of the lower layer, that we call the representation layer, is to represent the environment state and its evolution over the time. The environment is perceived as a whole of entities, directly or indirectly observable and of which states change permanently. These entities are modeled according to a taxonomic organisa- ∗Laboratoire d'Informatique, de Traitement de l'Information et des Syst`emes, University of Le Havre, 25 rue Philippe Lebon, 76058, Le Havre Cedex, France. Email:{fahem.kebair, frederic.serin, cyrille.bertelle}@univ-lehavre.fr tion and information that describe them are formatted according to a model of "semantic features", inspired by the memento design pattern rules [Gamma and al. 1995].

Moreover, the system apprehends these information via software agents (called factual agents) and according to an ontology of the studied domain. The collaboration of these agents and their comparisons with each other, form dynamic agents clusters. The latter are compared by past known scenarios. The final object of the study is to permit to prevent the occur of a crisis situation and to provide an emergency management planning. This modelling was elaborate starting from the game of Risk [Person 2005] and tested on the RoboCupRescue Simulation System (RCRSS) [RoboCupRescue]. In this paper, we provide a modelling of information extracted from an observed environment in an emergency context. Inside the system, information are managed thanks to factual agents that interact by comparing each other. The modelling includes a definition of a taxonomy. The latter was applied to the RCRSS environment, for which we have defined an ontology of the domain. The structure of the paper is as follows: first we present the general architecture of the DSS and its internal kernel. Then, we define the taxonomic organisation of the perceived environment. After that, we present the RCRSS environment and the ontology of the domain. Finally, we present factual agents and some tests using graphic tools.

## 2 Decision Support System

The role of the Decision Support System is quite wide. In general, the purpose is "to improve the decision making ability of managers (and operating personnel) by allowing more or better decisions within the constraints of cognitive, time, and economic limits"
[Holspace C.W. and al. 1996]. More specifically, the purposes of a DSS are: 
- **Supplementing the decision maker,** - **Allowing better intelligence, design, or choice,** - **Facilitating problem solving,** - Managing knowledge.