# On The Influence Of Selection Operators On Performances In Cellular Genetic Algorithms

D. Simoncini, P. Collard, S. Verel, M. Clergue Abstract**— In this paper, we study the influence of the selective**
pressure on the performance of cellular genetic algorithms.

Cellular genetic algorithms are genetic algorithms where the population is embedded on a toroidal grid. This structure makes the propagation of the best so far individual slow down, and allows to keep in the population potentially good solutions. We present two selective pressure reducing strategies in order to slow down even more the best solution propagation. We experiment these strategies on a hard optimization problem, the Quadratic Assignment Problem, and we show that there is a threshold value of the control parameter for both which gives the best performance. This optimal value does not find explanation on the selective pressure only, measured either by takeover time or diversity evolution. This study makes us conclude that we need other tools than the sole selective pressure measures to explain the performance of cellular genetic algorithms.

## Introduction

The selective pressure can be seen as the ability for solutions to survive in the population. When the selective pressure is high, only the best solutions survive and colonize the population, allowing less time for the algorithm to explore the search space. Thus, the selective pressure has an impact on the exploration/exploitation trade-off: When it is too low, good solutions' influence on the population is so weak that the algorithm can't converge and behave as a random search in the search space. When it is too strong, the algorithm converges quickly and as soon as it is stuck in a local optimum it won't be able to find better solutions.

Cellular Genetic Algorithms (cGA) are a subclass of Evolutionary Algorithms in which the population is embedded on a bidimensional toroidal grid. Each cell of the grid contains one individual (solution) and the stochastic operators are applied within the neighborhoods of each cell. The existence of such small overlapped neighborhoods guarantee the propagation of solutions through the grid and enhance exploration and population diversity [13]. Such a kind of algorithms is especially well suited for complex problems with multiple local optima [6]. To avoid the algorithm to converge toward one local optimum, one should apply the right selective pressure on the population and find the best balance between exploitation of good solutions and exploration of the search space.

Section 1 presents a state of the art on selective pressure in cGAs and introduces two selection operators. Section 2 compares the influence of the selection operators on the selective pressure. Section 3 gives a description of the benchmark used to analyze the algorithms. Section 4 presents a comparative study of performance of the algorithms. Section 5 is a study on the evolution of the genotypic diversity in the populations.

Finally in section 6 we summarize and discuss the results of the paper.

I. CELLULAR GENETIC ALGORITHMS AND SELECTIVE
PRESSURE
Several methods have been proposed to tune the selective pressure and deal with the exploration/exploitation trade-off in cGA. For instance, the size and shape of the cells neighborhoods in which the evolutionary operators are applied, has some influence. A bigger neighborhood will induce a stronger selective pressure on the population [10]. When trying to solve complex problems, with numerous local optima, one would try to slow down the convergence of the population. That is why we use in our algorithm a Von Neumann neighborhood which is the smallest symetric neighborhood that allows the convergence of the population.

The shape of the grid also has an impact on the selective pressure [1], [3], [4]: thinner grids give a weaker selective pressure on the population. This solution's weakness is that there are not enough grid shapes for a fixed size of population to allow an accurate control of the selective pressure.

The selective pressure can also be monitored by choosing an adequate selection operator.

## A. Stochastic Tournament Selection

The stochastic tournament selection proposed by Goldberg is a binary tournament selection that doesn't guarantee the best solution to be selected. The stochastic tournament of rater chooses two solutions from the neighborhood of a cell and selects the best one with probability1−r (the worst one with probabilityr). Real parameterr should be in [0; 1].

Given the definition of selective pressure, this selection operator explicitely gives a weaker selective pressure for increasingr values. Asr is getting closer to1, worse solutions increase their chances to be maintained in the population, which means the selective pressure is getting weaker.

## B. Anisotropic Selection

The Anisotropic selection is a selection method in which the neighbors of a cell may have different probabilities to be selected [12]. The Von Neumann neighborhood of a cellC is defined as the sphere of radius1 centered atC
in manhattan distance. The Anisotropic selection assigns different probabilities to be selected to the cells of the Von Neumann neighborhood according to their position. The probabilitypc to choose the center cellC remains fixed at 15
. Let us callpns the probability of choosing the cells North