# Review Of: Brigitte Le Roux And Henry Rouanet, Geometric Data Analysis, From Correspondence Analysis To Structured Data Analysis, Kluwer, Dordrecht, 2004, Xi+475 Pp.

The term "Geometric Data Analysis" is due to Patrick Suppes (Stanford) who writes a Foreword for this encyclopedic view of Correspondence Analysis. The uniqueness of this work lies in the detailed conceptual framework, and in showing how, where and why statistical inference methods come into play.

As a data analysis methodology, Correspondence Analysis is *formal* and geometric**. The former follows from the fact that mathematical "structures**
govern procedures", the mathematics carry the burden of demonstration, and ultimately "this means a fantastic saving in intellectual investment". The latter is due to the focus on clouds of points in geometric spaces. Unlike the sampling-oriented approach of a good deal of statistical data analysis, including multivariate data analysis, for Correspondence Analysis, "description comes first" since statistics is not reducible to probability.

The word "model" is used, in general, in lots and lots of senses (statistical, mathematical, physical models; mixture model; linear model; noise **model;**
neural network model; sparse decomposition model; even data model). So it is helpful that the methodological models under discussion in this book **are termed**
frame models. As a *geometric frame model***, it is also nice to see due emphasis**
given to "Euclidean classification" as a "companion method" of Correspondence Analysis. Euclidean classification is most in harmony with Correspondence Analysis when minimum variance (or Ward's) agglomerative hierarchical clustering is used. The data aggregates are defined in the same Correspondence Analysis metric spaces. The clustering is Euclidean because it is constructed in the Correspondence Analysis factor space.

In social sciences, there are "two distinct conceptions of the role **of statistics,**
namely sustaining a *sociology of variables* **versus** *constructing a social space*".

The former goes hand in hand with traditional statistical analysis, whereas the latter is part and parcel of Geometric Data Analysis. We will return to the construction of social space below with reference to Bourdieu.

As a "cornerstone" of Correspondence Analysis, one has the "measure versus variable duality", or the duality of the associated (row, column) vector spaces. When aggregated, the measures are summed, whereas the variables, when they are aggregated, are averaged. A transition notation where subscripts denote measures and superscripts denote variables is handy - much handier than matrix notation - for important aspects of the analysis. Among the latter **are: how** one's data departs from the "reference" marginal frequencies; **how one's data is** expressed as a "transition" from one to the other of these marginal frequencies; and how the χ 2 **metric is defined on the dual, complementary clouds.**
Discussing the suitability of Correspondence Analysis for structured data
(that is to say, structured around such variables as age and gender characteristics in a questionnaire), firstly having such structuring factors as supplementary variables allows for their incorporation into the analysis. Later, other analyses such as Analysis of Variance (ANOVA) could be very appropriate. Statistical