inference is a natural complement to descriptive analysis - as Benz´ecri wrote,
"The model should follow the data, not the reverse!" - and both phases together comprise a powerful way to inductively carry out data analysis.

Chapter 2 presents a most accessible and readable introduction to **Correspondence Analysis, based on the view of the measure versus variable duality.**
This leads to Correspondence Analysis being viewed as analysis of a measure over the Cartesian product with strictly positive marginals. All of the essentials of Correspondence Analysis are introduced, going as far as aids to **interpretation (e.g. contributions of points to the inertia of axes; quality of representation;**
data coding; supplementary elements; linkages with matrix expression, Fisher's linear discriminant analysis, regression, and canonical correlation analysis; links with multidimensional scaling; and how or where CA links up with probabilistic model frames). A range of questions end the chapter, with solutions and with comments.

Chapter 3 dealing with analysis of a Euclidean cloud of points proceeds by way of Huyghens, and spectral decomposition (i.e., eigenvalue, eigenvector decomposition) to concentration (hyper)ellipsoids, and following discussion of the partition of a cloud the reader is led to clustering. Pride of place is accorded agglomerative hierarchical clustering with the minimum variance criterion (Ward's method; "Euclidean classification" since the input consists of Euclidean projections on factors). The reciprocal nearest neighbors algorithm is described but not the nearest neighbor chain algorithm (which is more manageable from a computational complexity point of view, since it has an O(n 2
**) computational**
bound for most widely used agglomerative criteria). For the nearest neighbor chain and reciprocal nearest neighbor algorithms, which came out of Benz´ecri's lab in the early 1980s and are now in R and Clustan among other packages, see Murtagh (2005). The ultrametric is not discussed. For the view of Correspondence Analysis being a "tale of three metrics", χ 2
**, Euclidean and ultrametric,**
see Murtagh (2005). Chapter 3 ends with exercises and solutions.

Chapter 4 deals comprehensively with Principal Components Analysis, viewed from the points of view of formal description and also interpretation of results, through the prism of Correspondence Analysis. In terms of number of pages it is more than half the length of Dunteman (1989) (but admittedly shorter than the 500 page length Jolliffe, 2002). The treatment of PCA in Le Roux and Rouanet is unique and in the spirit of Geometrical Data Analysis.

In chapter 5, attention is given to Multiple Correspondence Analysis. A
paradigmatic case is questionnaire analysis, where each question has a number of response modalities, and just one among these response modalities is indicated by a subject. Much that is theoretical (e.g., Burt table; viewpoints **linked to** discriminant analysis, and canonical correlation analysis) and practical (e.g., choice of active questions; data coding for handling infrequent modalities) is covered. Before ending the chapter with questions and solutions, **there is a**
detailed case study, relating to a French Government survey of cultural and leisure activities (3002 respondents, carried out in 1997).

We have already mentioned "structured data" above. Examples of **such**
structuring context, available in addition to the essential data being studied,