
## Adaptive Affinity Propagation Clustering

Kaijun Wang 1, Junying Zhang 1, Dan Li 1, Xinna Zhang 2 and Tao Guo1 1 School of computer science and engineering, Xidian University, Xi'an 710071, P. R. China. 

2 China Jiliang College, Hangzhou 310018, P. R. China Email: sunice9@yahoo.com Abstract Affinity propagation clustering (AP) has two limitations: it is hard to know what value of parameter 'preference' can yield an optimal clustering solution, and oscillations cannot be eliminated automatically if occur. The adaptive AP method is proposed to overcome these limitations, including adaptive scanning of preferences to search space of the number of clusters for finding the optimal clustering solution, adaptive adjustment of damping factors to eliminate oscillations, and adaptive escaping from oscillations when the damping adjustment technique fails. Experimental results on simulated and real data sets show that the adaptive AP is effective and can outperform AP in quality of clustering results.

Keywords Affinity propagation clustering; Adaptive clustering; Large number of clusters 

## 1 Introduction

Affinity propagation clustering (AP) [1] is a fast clustering algorithm especially in the case of large number of clusters [2], and has some advantages: speed, general applicability and good performance. AP works based on similarities between pairs of data points (or n×n similarity matrix S for n data points), and simultaneously considers all the data points as potential cluster centers (called exemplars). To find appropriate exemplars, AP accumulates evidence "responsibility" R(i,k) from data point i for how well-suited point k is to serve as the exemplar for point i, and accumulates evidence "availability" A(i,k) from candidate exemplar point k for how appropriate it would be for point i to choose point k as its exemplar. From the view of evidence, larger the R(:,k)+A(:,k), more probability the point k as a final cluster center. Based on evidence accumulation, AP searches for clusters through an iterative process until a high-quality set of exemplars and corresponding clusters emerges. In the iterative process, identified exemplars start from the maximum n exemplars to fewer exemplars until m exemplars appear and are unchanging any more (or AP algorithm converges). The m clusters found based on m exemplars are the clustering solution of AP. 

There are two important parameters in AP: the preferences (p) in diagonal of similarity matrix S and the damping factor (lam). The preference parameter p(i) (its initial value is negative) indicates the preference that data point i be chosen as a cluster center, and influences output clusters and the number of clusters (NC).

The main formula in the AP algorithm are: R(i,k) = S(i,k)–max{A(i,j)+S(i,j)}, where j∈{1,2,…,n} but j≠k; and A(i,k) = min{0, R(k,k)+sum{max(0,R(j,k))}}, where j∈{1,2,…,n} but j≠i and j≠k; and p appears in R(k,k)=p(k)–max{A(k,j)+S(k,j)}. Hence, the p influences which and how many exemplars will win as final cluster centers, i.e., when p(k) is larger, R(k,k) and A(i,k) are larger, so that it has more probability that the point k is as a final cluster center. This means that the number of identified clusters is increased or decreased by adjusting p correspondingly, and usually a good choice is to set all the p(i) to be the median (pm) of all the similarities between data points [1]. However, the pm can not lead to an optimal clustering solution in many cases, since the pm is not given on the basis of the optimal cluster structure of a data set. Furthermore, there is no exact corresponding relation between the p and output NC. Therefore, how to find an optimal clustering solution is an unsolved problem for using AP algorithm.

In each iterative step i, R and A are updated with the one in last iteration, i.e., Ri = (1-lam)×Ri + *lam*×Ri-1, Ai = (1-lam)×Ai + *lam*×Ai-1, where damping factor *lam*∈[0,1] and default lam=0.5. Another function of the damping factor is to improve convergence when AP fails to converge on account of oscillations (or identified exemplars are in periodic variation), where lam needs to be increased to eliminate oscillations [1]. In un-convergent cases, we have to increase lam manually and gradually and rerun AP until the algorithm converges. Another choice is to use a big damping factor close to 1 to eliminate oscillations, but AP will run very slow. Both choices may consume plenty of time, especially for a large data set. Hence, it is an important problem for AP: how to automatically eliminate oscillations when oscillations occur?

To solve these problems, we propose adaptive AP, including: adaptive adjustment of the damping factor to eliminate oscillations (called adaptive damping), adaptive escaping oscillations by decreasing p when adaptive damping method fails (called adaptive escape), and adaptive searching the space of p to find out the optimal clustering solution suitable to a data set (called adaptive preference scanning). The adaptive AP is proposed in Section 2, and experimental results are in Section 3. Finally, Section 4 gives the conclusion. 

The Matlab codes of the adaptive AP are available from ref. [10].

1 