With Sil(t) for each sample, overall average silhouette Sil for n samples of the data set is obtained directly.

The largest overall average silhouette indicates the best clustering quality and the optimal NC [3]. Using formula (1), a series of Sil values corresponding to clustering solutions under different NCs are calculated, and the optimal clustering solution is found at the largest Sil. 

![0_image_0.png](0_image_0.png)

![0_image_1.png](0_image_1.png)

## 3 Experimental Results

This section compares the clustering performance between adaptive AP method (adAP) and AP algorithm
(AP). The items of clustering performance include: whether adAP can eliminate oscillations (if oscillations occur) automatically so as to give correct clustering results, whether adAP can give correct clustering results based on the Silhouette index (or cluster validation technique). The adAP and AP use same initial lam=0.5 
(but lam=0.8 in Travelroute experiment), and AP uses fixed p=pm and *maxits*=2000. For Document and Travelroute experiments, both methods use fixed p from prior knowledge [1]. 

Let a data set be an n×d matrix X={xi}, where xi is d-dimensional. For general data, the similarity between sample xi and xj is 2 b x ij - = || i − xj || based on Euclidean distances, while for gene expression data the Pearson coefficients are used as similarity measure, i.e., the linear relationship between two samples xi and xj
(their means xi and xj ) is: 

$$R(i,j)={\frac{\sum_{l=1}^{d}(X_{i l}-{\overline{{X}}}i)(X_{j l}-{\overline{{X}}}_{j})}{\sqrt{\sum_{l=1}^{d}(X_{i l}-{\overline{{X}}}i)^{2}}}}{\sqrt{\sum_{l=1}^{d}(X_{i l}-{\overline{{X}}}i)^{2}}}}$$

$$(2)$$

To avoid possible calculation confusion from negative values, the R(i,j)∈[-1,1] is transformed to R(i,j)= 
1−(1+R(i,j))/2. Thus, Pearson coefficients are transformed to positive Pearson distance R(i,j)∈[0,1] (bigger the value, farther the two samples), and the similarity between sample xi and xj is bij= -R(i,j). 

Twelve data sets in Table 3 are used in the experiments, where the first eight data sets have known class labels. Their features include: far and close well-separated clusters, slight overlapping clusters, tight clusters and loose clusters. The first four data sets are simulated data, while other data sets are real data. The Yeast and NCI60 are gene expression data, and a subset of dataset Exons is used, i.e., the first 3499 samples and the last one (= 3500 samples) from 75067 samples are used. 