
## Example 14 (Seating)

We must arrange a seating for a number n **of agents (representing, for instance,** people invited to the wedding party introduced in Example 1), with m **tables and**
a maximum of c **chairs per table. Agents who like each other should sit at the same**
table; agents who dislike each other should not sit at the same table. **Moreover, an** agent can express some requirements w.r.t. the number and the identity of other agents sitting at the same table. Assume that the I**-th agent is represented by a** predicate agent(I**) and his knowledge base is enclosed in a single SOLP program.** Each program will include both a set of common rules encoding the problem and the agent's own requirements. The predicate like(A**) (resp.** dislike(A**)) means that**
the agent A is desired (resp. not tolerated) at the same table. table(T**) represents**
a table (1 ≤ T ≤ m) and at(T) expresses the desire to sit at table T**. For instance,**
the program P1 **(which is associated with the agent 1) could be written as follows:**

r1 : **agent**(1) ←
$$\begin{array}{r l}{a y c l}{\leftarrow{}}&{{}}&{{}}\\ {\leftarrow{}}&{{}}&{{}}{a t(T1),a t(T2),\,T1<>T2}\\ {a t(T)\leftarrow{}}&{{}}&{{}[c,]\{a t(T),\,a g e n t(P)\},\,i k e(P),\,t a b l e(T)}\\ {\leftarrow{}}&{{}}&{{}}\\ {\leftarrow{}}&{{}}&{{}a t(T),[1,]\{a t(T),\,a g e n t(P)\},\,d i s l i k e(P)}\\ {\leftarrow{}}&{{}}&{{}}\\ {l i k e(2)\leftarrow{}}&{{}}&{{}}\\ {d s l i k e(3)\leftarrow{}}&{{}}&{{}}\\ {y(l i k e(4))\leftarrow{}}&{{}}&{{}}\\ {\leftarrow{}}&{{}}&{{}a t(T),[3,]\{a t(T)\}}\end{array}$$
r6 : **like**(2) ←
r7 : **dislike**(3) ←
r8 : okay(**like**(4)) ←
where the rules from r1-r5 **are common to all the programs (of course, the argument**
of the predicate agent() in r1 **is suited to the enclosing program) and the rules** r6-r9 express the agent's own requirements. In detail, the rule r2 **states that any agent**
cannot be seated at more than one table, the rule r3 **means that agent 1 sits at a**
particular table T if at least c agents he likes are seating at that table (c **is a given**
constant). The rule r4 **states that it is forbidden that agent 1 shares a table with**
at least one or more agents he dislikes.

The rule r5 **provides consistency for the predicates** like and dislike**, while examples**
of such predicates are reported in rules r6 and r7. The rule r8 **is used to declare that**
agent 1 tolerates agent 4, i.e. agent 4 possibly shares a table with agent 1, and finally the rule r9 **means that the agent 1 does not want to share a table with 3 agents** or more. Observe that while the rule r3 **generates possible seating arrangements, the**
rules r2, r4 and r9 **discard those which are not allowed.**

## Example 15 (Room Arrangement)

Consider a house having m **rooms. We have to distribute some objects (i.e. furniture** and appliances) over the rooms in such a way that we do not exceed the maximum number of objects, say c**, allowed per room. Constraints about the color and/or** the type of objects sharing the same room can be introduced. We assume that each object is represented by a single program encoding both the properties and the constraints we want to meet. Consider the following program: