
## Example 17 (Contextual Reasoning)

It is interesting to observe that SOLP programs can represent a form of Contextual Reasoning (Ghidini and Giunchiglia 2001).

Although many definitions of the notion of context **exist in the Artificial Intelligence literature (McCarthy 1993; Ghidini and Giunchiglia 2001; Br´ezillon 1999),**
we can informally say that a context is an environment (i.e. a set of facts and the logic rules to perform inference with) in which the reasoning takes place.

In particular, in (Ghidini and Giunchiglia 2001) two key principles of contextual reasoning are stated: locality **(the reasoning task uses only a subset of the total knowledge available) and** compatibility **(additional constraints among different**
contexts may be specified to declare those which are mutually compatible).

Under this perspective, we are interested in representing this feature of commonsense reasoning, that is, given a problem to be solved, (i) bounding the reasoning to the knowledge which is strictly needed, the so-called context **of the problem, and** (ii), in case the original context is not suitable to reach a solution, enabling the use of new information provided by other contexts.

It is interesting to note that SOLP programs are well-suited to represent contexts, since each of them enables reasoning which takes place both locally, i.e. at the level of the program knowledge base, and at the level of the other programs' knowledge bases. Thus, it is easy to model reasoning which involves several different contexts.

For instance, consider a SOLP program P0 **(representing the context of the agent**
A0**) including a social rule of the form**

## Action ← [P1]B1, **· · ·** , [Pn]Bn

meaning that the agent A0 **infers the term** action if each term bi (1 ≤ i ≤ n**) is**
inferred by the corresponding agent Ai, i.e. bi**is part of an autonomous fixpoint of**
Pi**. This way, the notion of locality is realized by representing each different context**
in a separate SOLP program, and the compatibility principle is pursued **by suitably** using SCs where member selection conditions identify contexts.

As an example, consider the well-known "Three Wise Men Puzzle", first introduced in (Konolige 1984).

A king wishes to determine which of his three wise men is the wisest. He arranges them in a circle so that they can see and hear each other and tells them that he will put a white or a black spot on each of their foreheads but that at least one *spot will be white. He then* repeatedly asks them, "Do you know the colour of your spot?". *What do they answer?*
We represent by means of SOLP programs a slightly simpler version of **the puzzle,**
where only two wise men are involved: