r1 : color(**white**) ← r2 : color(**black**) ←

| King (agent K)   |                      |                                                                                                                             |
|------------------|----------------------|-----------------------------------------------------------------------------------------------------------------------------|
| r3 :             | wise man(1..2) ←     |                                                                                                                             |
| r4 :             | put spot(A, black) ← | not put spot(A, white),wise man(A)                                                                                          |
| r5 :             | put spot(A, white) ← | not put spot(A, black), wise man(A)                                                                                         |
| r6 :             | ←                    | #count{S : put spot(S, black)} = N , #count{A : wise man(A)} = N , #int(N )                                                 |
| r7 :             | ask question(1) ←    |                                                                                                                             |
| r8 :             | ask question(T2) ←   | ask question(T1), #succ(T1, T2), #int(T1), #int(T2) not [1, ]{answer(white, T1), answer(black, T1)}, Wise man 1 (agent W 1) |
| r9 :             | forehead(C ) ←       | [K]{put spot(1, C )}, color(C )                                                                                             |
| r10 :            | answer(white, 1) ←   | [K]{ask question(1)}, [W 2]{forehead(black)}                                                                                |
| r11 :            | answer(black, 1) ←   | [K]{ask question(1)}, [W 2]{forehead(white), answer(white, 1)}                                                              |
| r12 :            | answer(white, 2) ←   | [K]{ask question(2)}, [W 2]{forehead(white), not answer(white, 1), not answer(black, 1)}                                    |

Rules r1-r2 **are common to each SOLP program. Such rules set the admissible**
spot colors. Rules r3-r8 represent the king. Rule r3 **sets the number of wise men**
(two in this case). By means of rules r4-r5**, the king non-deterministically puts** a spot on each wise man's forehead. Rule r6 **represents the king's statement "At**
least one spot is white". The king asks the question for the first time **(rule** r7)
and, after he has asked the question, if no agent gives an answer, **then he asks the**
question again (rule r8). Rule r9 **is used to store into the predicate** forehead the information about the color of the corresponding wise man's spot. Observe that since each wise man cannot look at his own forehead, then the predicate forehead is further referenced in SCs only. Rules r10 − r11 **represent the case of exactly one**
white spot: after the first time the king asks the question, if the first wise man sees a black spot on the other wise man's forehead, then he concludes that his spot is white (rule r10**). Otherwise, if the second wise man both has a white spot on his**
forehead and he answers "white", then the first wise man can conclude that the other wise man has seen a black spot on his forehead. Thus, the first wise man answers "black". Finally, rule r12 **represents the case of two white spots. In such a**
case, after the first question, no wise man can conclude anything about the color of his own spot. After the second time the king asks the question, each wise man can answer "white" in case he sees a white spot and the other wise man has not answered the previous king's question. The correctness of such a **statement can be** proved by contradiction: if a wise man had a black spot on his forehead, then the other wise man would have seen it and, thus, he also would have answered "white" after the first king's question.

The SOLP program representing the second wise man (program W **2) is easily**
obtained from W **1 by exchanging the role of the two wise men, i.e. by replacing** each occurrence of the program identifier W **2 by** W 1.

For the sake of the simplicity we have considered a simple scenario, i.e. two wise