on extended logic programming, allowing to define and study properties that can be enforced by its operational model.

Since our approach relies on the general notion of social behaviour, it is of course interesting to illustrate how this concept is dealt with in the related field of intelligent agents, in order to make evident that - even in such context - **this notion takes**
an important role. Indeed, beside autonomy**, intelligent agents (Wooldridge and Jennings 1995;**
Wooldridge 2000) may be required to have social ability**. The meaning of this concept is two-fold: (1) the presence of a common language for communication, and (2)**
the capability of reasoning on the content of communication acts. Concerning item
(1), KQML (Mayfield and Finin 1995), and FIPA ACL (Cost et al. 2001), both based on the speech act theory (Cohen and Levesque 1990), represent the main efforts done in the last years. The state-of-the-art literature on **item (2) is represented** by (Wooldridge 2000; van der Hoek and Wooldrige 2003; Mascardi et **al. 2004). Social ability allows thus the agent individuals to have** beliefs, desires and intentions
(BDI) (Rao and Georgeff 1995; Rao 1996) as a result of both the mutual communication and the consequent individual reasoning.

## 9 Conclusions And Future Work

In this paper we have proposed a new language, Social Logic Programming **(SOLP),**
which extends Compromise Logic Programming and enables social behaviour among a community of individuals whose reasoning is represented by logic programs. A
rich set of examples shows that the language has very nice capabilities of representing such a kind of knowledge. Moreover, we have given a translation from SOLP to logic programming with aggregates and discussed the computational complexity of several decision problems related to the social semantics.

Basically, the present paper gives the theoretical core for a multi-agent oriented software environment, including suitable specialized features, like information hiding, speech-act mechanisms, security and so on. However, these **issues are interesting**
directions of our future work.

For instance, information hiding can be implemented as follows. Given a **SOLP**
collection C**, we make the following assumption: by default each agent cannot see**
into other agents' mind, that is all atoms in each SOLP program are viewed only by the program itself, i.e. they are private. In order to make some atom public we could add a suffix, say P, to such an atom, i.e. a **is meant as private, while** aP is meant as the public version of a**. Then, by means of a suitable modification of our** translation machinery, any social condition can be activated only on **public atoms.**
An agent communication machinery can be conceived that relies on the above feature. In case an agent wants to send a message to another agent, then the former could make public a suitable set of atoms in such a way that they are visible only to the latter. This approach could be easily extended to the scenario where one agent wants to send a message to either a group of agents or to the whole **community.**
Another feature we intend to include into future extensions of SOLP is the representation of evolving agent mental states. We believe that a collection of SOLP
programs could be easily managed by some existing logic framework which is tai-